/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.cyclops.capabilityproxy.blockentity.BlockEntityItemCapabilityProxyCommon;
import org.cyclops.cyclopscore.fluid.FluidHandlerWrapper;

public class BlockEntityItemCapabilityProxyNeoForge
extends BlockEntityItemCapabilityProxyCommon {
    public static Map<BlockCapability<?, ?>, ItemCapability<?, ?>> BLOCK_TO_ITEM_CAPABILITIES;

    public BlockEntityItemCapabilityProxyNeoForge(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    @Override
    protected void onInventoryChanged() {
        super.onInventoryChanged();
        this.level.invalidateCapabilities(this.getBlockPos());
    }

    public <T, C1, C2> T getCapability(BlockCapability<T, C1> blockCapability, C1 context) {
        if (context instanceof Direction && context == this.getFacing() && blockCapability == Capabilities.ItemHandler.BLOCK) {
            return (T)new InvWrapper((Container)this.getInventory());
        }
        ItemStack itemStack = this.getContents();
        ItemCapability<T, C2> itemCapability = BlockEntityItemCapabilityProxyNeoForge.blockCapabilityToItemCapability(blockCapability);
        if (itemCapability == null) {
            return null;
        }
        Object cap = itemStack.getCapability(itemCapability, itemCapability.contextClass() == Direction.class ? this.getFacing().getOpposite() : null);
        if (cap instanceof IFluidHandlerItem) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap;
            cap = new FluidHandlerWrapperItem(fluidHandlerItem, this);
        }
        return (T)cap;
    }

    @Nullable
    public static <T, C1, C2> ItemCapability<T, C2> blockCapabilityToItemCapability(BlockCapability<T, C1> capability) {
        return BLOCK_TO_ITEM_CAPABILITIES.get(capability);
    }

    public static class FluidHandlerWrapperItem
    extends FluidHandlerWrapper
    implements IFluidHandlerItem {
        private final IFluidHandlerItem fluidHandler;
        private final BlockEntityItemCapabilityProxyNeoForge tile;

        public FluidHandlerWrapperItem(IFluidHandlerItem fluidHandler, BlockEntityItemCapabilityProxyNeoForge tile) {
            super((IFluidHandler)fluidHandler);
            this.fluidHandler = fluidHandler;
            this.tile = tile;
        }

        protected void updateContainerSlot() {
            this.tile.getInventory().setItem(0, this.getContainer());
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int ret = super.fill(resource, action);
            if (action.execute()) {
                this.updateContainerSlot();
            }
            return ret;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack ret = super.drain(maxDrain, action);
            if (action.execute()) {
                this.updateContainerSlot();
            }
            return ret;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack ret = super.drain(resource, action);
            if (action.execute()) {
                this.updateContainerSlot();
            }
            return ret;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.fluidHandler.getContainer();
        }
    }
}

