/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay;

import dev.boxadactle.boxlib.command.BCommandManager;
import dev.boxadactle.boxlib.command.api.BCommand;
import dev.boxadactle.boxlib.config.BConfigClass;
import dev.boxadactle.boxlib.config.BConfigHandler;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.boxlib.rendering.RenderQueue;
import dev.boxadactle.boxlib.rendering.Renderer3D;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.ModLogger;
import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.CompassRenderer3D;
import dev.boxadactle.coordinatesdisplay.Hud;
import dev.boxadactle.coordinatesdisplay.ModConfig;
import dev.boxadactle.coordinatesdisplay.command.CoordinatesCommand;
import dev.boxadactle.coordinatesdisplay.marking.MarkPosRenderer;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.class_332;

public class CoordinatesDisplay {
    public static final String MOD_NAME = "CoordinatesDisplay";
    public static final String MOD_ID = "coordinatesdisplay";
    public static final String VERSION = "15.0.0";
    public static final String VERSION_STRING = "CoordinatesDisplay v15.0.0";
    public static final String WIKI = "https://boxadactle.dev/wiki/coordinates-display/";
    public static String WIKI_VISUAL = "https://boxadactle.dev/wiki/coordinates-display/#visual";
    public static String WIKI_RENDER = "https://boxadactle.dev/wiki/coordinates-display/#rendering";
    public static String WIKI_COLOR = "https://boxadactle.dev/wiki/coordinates-display/#color";
    public static String WIKI_DEATHPOS = "https://boxadactle.dev/wiki/coordinates-display/#deathpos";
    public static String WIKI_TEXTS = "https://boxadactle.dev/wiki/coordinates-display/#text";
    static boolean deltaError = false;
    public static final ModLogger LOGGER = new ModLogger("CoordinatesDisplay");
    public static boolean shouldHudRender = true;
    public static BConfigClass<ModConfig> CONFIG;
    public static Hud HUD;
    public static Vec3<Integer> MARK_POS;

    public static void init() {
        CONFIG = BConfigHandler.registerConfig(ModConfig.class);
        HUD = new Hud();
        RenderQueue.addRenderer((Renderer3D)new CompassRenderer3D());
        RenderQueue.addRenderer((Renderer3D)new MarkPosRenderer());
    }

    public static ModConfig getConfig() {
        return (ModConfig)CONFIG.get();
    }

    public static void renderHud(class_332 graphics) {
        try {
            if (HUD.shouldRender(CoordinatesDisplay.getConfig().visibilityFilter)) {
                ModConfig config = CoordinatesDisplay.getConfig();
                HUD.render(graphics, Hud.RenderType.HUD, Position.of(WorldUtils.getPlayer()), config.hudX, config.hudY, config.renderMode, config.startCorner, config.hudScale);
            }
        }
        catch (NullPointerException e) {
            if (deltaError) {
                throw new RuntimeException(e);
            }
            LOGGER.error((Object)"Unknown error from config file", new Object[0]);
            LOGGER.printStackTrace((Exception)e);
            CoordinatesDisplay.LOGGER.player.warn(GuiUtils.getTranslatable((String)"message.coordinatesdisplay.configError"), new Object[0]);
            CONFIG.resetConfig();
            deltaError = true;
        }
    }

    static {
        MARK_POS = null;
        LOGGER.info((Object)"Initializing CoordinatesDisplay v15.0.0", new Object[0]);
        BCommandManager.register((BCommand)CoordinatesCommand.createCommand());
    }
}

