/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay;

import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.boxlib.math.mathutils.NumberFormatter;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.RenderUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.ModConfig;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import oshi.util.tuples.Triplet;

public interface HudRenderer {
    default public ModConfig config() {
        return CoordinatesDisplay.getConfig();
    }

    default public void drawInfo(class_332 guiGraphics, class_2561 component, int x, int y, int color) {
        RenderUtils.drawText((class_332)guiGraphics, (class_2561)component, (int)x, (int)y, (int)color);
    }

    default public String getTranslationKey() {
        return this.getNameKey() + ".";
    }

    default public String getNameKey() {
        HudDisplayMode metadata = this.getClass().getAnnotation(HudDisplayMode.class);
        if (metadata != null) {
            if (!metadata.translationKey().isEmpty()) {
                return metadata.translationKey();
            }
            return "hud.coordinatesdisplay." + metadata.value();
        }
        throw new RuntimeException("Cannot use hud text helpers without specifying a translation key!");
    }

    default public class_2561 translation(String t, Object ... args) {
        return class_2561.method_43469((String)(this.getTranslationKey() + t), (Object[])args);
    }

    default public class_2561 definition(class_2561 t) {
        return GuiUtils.colorize((class_2561)t, (int)CoordinatesDisplay.getConfig().definitionColor);
    }

    default public class_2561 definition(String t) {
        return GuiUtils.colorize((class_2561)class_2561.method_43470((String)t), (int)CoordinatesDisplay.getConfig().definitionColor);
    }

    default public class_2561 definition(GlobalTexts t, Object ... args) {
        return this.definition(t.get(args));
    }

    default public class_2561 definition(String k, Object ... args) {
        return this.definition(this.translation(k, args));
    }

    default public class_2561 value(String t) {
        return GuiUtils.colorize((class_2561)class_2561.method_43470((String)t), (int)CoordinatesDisplay.getConfig().dataColor);
    }

    default public class_2561 value(class_2561 t) {
        return GuiUtils.colorize((class_2561)t, (int)CoordinatesDisplay.getConfig().dataColor);
    }

    default public class_2561 value(GlobalTexts t, Object ... args) {
        return this.value(t.get(args));
    }

    default public class_2561 resolveDirection(String direction, boolean useShort) {
        String key = "hud.coordinatesdisplay." + direction;
        if (useShort) {
            key = key + ".short";
        }
        return class_2561.method_43471((String)key);
    }

    default public class_2561 resolveDirection(String direction) {
        return this.resolveDirection(direction, false);
    }

    public static Rect<Integer> renderHud(class_332 guiGraphics, RenderingLayout hudRenderer, boolean background) {
        Rect r = hudRenderer.calculateRect();
        if (CoordinatesDisplay.getConfig().renderBackground && background) {
            RenderUtils.drawSquare((class_332)guiGraphics, (Rect)r, (int)CoordinatesDisplay.getConfig().backgroundColor);
        }
        hudRenderer.render(guiGraphics);
        return r;
    }

    default public Triplet<String, String, String> roundPosition(Vec3<Double> pos, Vec3<Integer> blockPos, int decimalPlaces) {
        if (decimalPlaces == 0) {
            return new Triplet((Object)Integer.toString((Integer)blockPos.getX()), (Object)Integer.toString((Integer)blockPos.getY()), (Object)Integer.toString((Integer)blockPos.getZ()));
        }
        NumberFormatter n = new NumberFormatter(decimalPlaces);
        return new Triplet((Object)n.formatDecimal((Number)((Double)pos.getX())), (Object)n.formatDecimal((Number)((Double)pos.getY())), (Object)n.formatDecimal((Number)((Double)pos.getZ())));
    }

    default public Triplet<class_2561, class_2561, class_2561> createXYZ(String x, String y, String z) {
        return new Triplet((Object)this.definition(GlobalTexts.X, this.value(x)), (Object)this.definition(GlobalTexts.Y, this.value(y)), (Object)this.definition(GlobalTexts.Z, this.value(z)));
    }

    default public Triplet<class_2561, class_2561, class_2561> createXYZ(int x, int y, int z) {
        return this.createXYZ(Integer.toString(x), Integer.toString(y), Integer.toString(z));
    }

    default public NumberFormatter<Double> genFormatter() {
        return new NumberFormatter(CoordinatesDisplay.getConfig().decimalPlaces);
    }

    public RenderingLayout renderOverlay(int var1, int var2, Position var3);

    public static enum GlobalTexts {
        X("hud.coordinatesdisplay.x"),
        Y("hud.coordinatesdisplay.y"),
        Z("hud.coordinatesdisplay.z"),
        XYZ("hud.coordinatesdisplay.xyz"),
        CHUNK_X("hud.coordinatesdisplay.chunk_x"),
        CHUNK_Y("hud.coordinatesdisplay.chunk_y"),
        CHUNK_Z("hud.coordinatesdisplay.chunk_z"),
        FACING("hud.corodinatesdisplay.facing"),
        BIOME("hud.coordinatesdisplay.biome"),
        DIMENSION("hud.coordinatesdisplay.dimension"),
        DAY("hud.coordinatesdisplay.day");

        final String key;

        private GlobalTexts(String key) {
            this.key = key;
        }

        public class_2561 get(Object ... args) {
            return class_2561.method_43469((String)this.key, (Object[])args);
        }
    }
}

