/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.registry;

import dev.boxadactle.boxlib.core.BoxLib;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.renderer.ChunkRenderer;
import dev.boxadactle.coordinatesdisplay.renderer.DefaultRenderer;
import dev.boxadactle.coordinatesdisplay.renderer.DirectionRenderer;
import dev.boxadactle.coordinatesdisplay.renderer.HotbarRenderer;
import dev.boxadactle.coordinatesdisplay.renderer.LineRenderer;
import dev.boxadactle.coordinatesdisplay.renderer.MaxRenderer;
import dev.boxadactle.coordinatesdisplay.renderer.MinRenderer;
import dev.boxadactle.coordinatesdisplay.renderer.NetherOverworldRenderer;
import dev.boxadactle.coordinatesdisplay.renderer.SpawnpointRenderer;
import net.minecraft.class_2561;

public enum DisplayMode {
    DEFAULT(DefaultRenderer.class),
    MINIMUM(MinRenderer.class),
    MAXIMUM(MaxRenderer.class),
    LINE(LineRenderer.class),
    NETHER_OVERWORLD(NetherOverworldRenderer.class),
    HOTBAR(HotbarRenderer.class),
    SPAWNPOINT(SpawnpointRenderer.class),
    DIRECTION(DirectionRenderer.class),
    CHUNK(ChunkRenderer.class);

    final HudRenderer renderer;
    final HudDisplayMode metadata;

    private DisplayMode(Class<? extends HudRenderer> renderer) {
        this.renderer = (HudRenderer)BoxLib.initializeClass(renderer);
        HudDisplayMode m = renderer.getAnnotation(HudDisplayMode.class);
        if (m == null) {
            throw new IllegalStateException("Attempting to register Hud renderer without DisplayMode annotation!");
        }
        this.metadata = m;
    }

    public HudRenderer getRenderer() {
        return this.renderer;
    }

    public HudDisplayMode getMetadata() {
        return this.metadata;
    }

    public class_2561 getComponent() {
        return class_2561.method_43471((String)this.renderer.getNameKey());
    }

    public String getName() {
        return GuiUtils.getTranslatable((String)this.renderer.getNameKey());
    }

    public String getId() {
        return this.metadata.value();
    }

    public static DisplayMode previousMode(DisplayMode mode) {
        DisplayMode[] values = (DisplayMode[])((Object)((Object)mode)).getClass().getEnumConstants();
        int currentIndex = 0;
        for (DisplayMode value : values) {
            if (value == mode) break;
            ++currentIndex;
        }
        if (currentIndex <= 0) {
            return values[values.length - 1];
        }
        return values[currentIndex - 1];
    }

    public static DisplayMode nextMode(DisplayMode mode) {
        DisplayMode[] values = (DisplayMode[])((Object)((Object)mode)).getClass().getEnumConstants();
        int currentIndex = 0;
        for (DisplayMode value : values) {
            if (value == mode) break;
            ++currentIndex;
        }
        if (++currentIndex < values.length) {
            return values[currentIndex];
        }
        return values[0];
    }
}

