/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.CenteredParagraphComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.math.geometry.Dimension;
import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.Hud;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudPositionModifier;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.mixin.OverlayMessageTimeAccessor;
import dev.boxadactle.coordinatesdisplay.position.Position;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import oshi.util.tuples.Triplet;

@HudDisplayMode(value="hotbar", ignoreTranslations=true, positionModifier=HotbarPosition.class, allowMove=false, hasBackground=false, hasChunkData=false, hasDirectionInt=false, hasMCVersion=false, hasDimension=false)
public class HotbarRenderer
implements HudRenderer {
    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        if (((OverlayMessageTimeAccessor)ClientUtils.getClient().field_1705).getOverlayMessageTime() > 0) {
            return new ColumnLayout(0, 0, 0);
        }
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        Triplet<String, String, String> player = this.roundPosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), CoordinatesDisplay.getConfig().decimalPlaces);
        if (this.config().renderXYZ) {
            components.add(this.definition(HudRenderer.GlobalTexts.XYZ, this.value((String)player.getA()), this.value((String)player.getB()), this.value((String)player.getC())));
        }
        if (this.config().renderDirection) {
            components.add(this.definition(HudRenderer.GlobalTexts.FACING, this.value(this.resolveDirection(ModUtil.getDirectionFromYaw(pos.headRot.wrapYaw())))));
        }
        if (this.config().renderBiome) {
            class_2960 bKey = pos.world.getBiomeKey();
            class_1959 b = pos.world.getBiome();
            components.add(ModUtil.getBiomeComponent(bKey, b, this.config().biomeColors, this.config().dataColor));
        }
        if (this.config().renderDay) {
            components.add(this.definition(HudRenderer.GlobalTexts.DAY, this.value(Long.toString(pos.world.getDay()))));
        }
        class_5250 all = class_2561.method_43473();
        Iterator it = components.iterator();
        while (it.hasNext()) {
            all.method_10852((class_2561)it.next());
            if (!it.hasNext()) continue;
            all.method_10852((class_2561)class_2561.method_43470((String)" / "));
        }
        ColumnLayout hud = new ColumnLayout(x, y, 0);
        hud.addComponent((LayoutComponent)new CenteredParagraphComponent(0, new class_2561[]{this.definition((class_2561)all)}));
        return hud;
    }

    public static class HotbarPosition
    implements HudPositionModifier.BasicPositionModifier {
        @Override
        public Rect<Integer> getPosition(Rect<Integer> rect, Dimension<Integer> ignored, Hud.RenderType type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case Hud.RenderType.SCREEN -> rect;
                case Hud.RenderType.HUD -> {
                    int j = ClientUtils.getClient().method_22683().method_4486() / 2;
                    int k = ClientUtils.getClient().method_22683().method_4502() - 68 - 4;
                    Rect r = rect.clone();
                    r.setX((Number)(j - (Integer)rect.getWidth() / 2));
                    r.setY((Number)k);
                    yield r;
                }
            };
        }
    }
}

