/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.boxlib.util.RenderUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import oshi.util.tuples.Triplet;

@HudDisplayMode(value="spawnpoint", hasChunkData=false, hasDirection=false, hasDirectionInt=false, hasBiome=false, hasMCVersion=false, hasDimension=false, hasDay=false)
public class SpawnpointRenderer
implements HudRenderer {
    public class_2338 resolveWorldSpawn() {
        try {
            return WorldUtils.getWorld().method_74854().method_74897();
        }
        catch (Exception e) {
            return new class_2338(0, 0, 0);
        }
    }

    private class_3545<Vec3<Double>, Vec3<Integer>> createRelativePosition(Vec3<Double> playerVec, Vec3<Integer> playerBlock, class_2338 spawn) {
        int spawnX = spawn.method_10263();
        int spawnY = spawn.method_10264();
        int spawnZ = spawn.method_10260();
        Vec3 relativeVec = new Vec3((Number)((Double)playerVec.getX() - (double)spawnX), (Number)((Double)playerVec.getY() - (double)spawnY), (Number)((Double)playerVec.getZ() - (double)spawnZ));
        Vec3 relativeBlock = new Vec3((Number)((Integer)playerBlock.getX() - spawnX), (Number)((Integer)playerBlock.getY() - spawnY), (Number)((Integer)playerBlock.getZ() - spawnZ));
        return new class_3545((Object)relativeVec, (Object)relativeBlock);
    }

    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        class_2338 spawnpoint = this.resolveWorldSpawn();
        ColumnLayout hud = new ColumnLayout(0, 0, this.config().textPadding);
        RowLayout row1 = new RowLayout(0, 0, this.config().textPadding);
        RowLayout row2 = new RowLayout(0, 0, this.config().textPadding);
        if (this.config().renderXYZ) {
            class_2561 playerLabel = this.definition("player", "");
            Triplet<String, String, String> player = this.roundPosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), CoordinatesDisplay.getConfig().decimalPlaces);
            Triplet<class_2561, class_2561, class_2561> xyz = this.createXYZ((String)player.getA(), (String)player.getB(), (String)player.getC());
            ParagraphComponent component = new ParagraphComponent(0, new class_2561[]{playerLabel, (class_2561)xyz.getA(), (class_2561)xyz.getB(), (class_2561)xyz.getC()});
            row1.addComponent((LayoutComponent)component);
        }
        class_2561 spawnpointLabel = this.definition("worldSpawn", "");
        Triplet<class_2561, class_2561, class_2561> spawnpointXYZ = this.createXYZ(spawnpoint.method_10263(), spawnpoint.method_10264(), spawnpoint.method_10260());
        ParagraphComponent component = new ParagraphComponent(0, new class_2561[]{spawnpointLabel, (class_2561)spawnpointXYZ.getA(), (class_2561)spawnpointXYZ.getB(), (class_2561)spawnpointXYZ.getC()});
        row1.addComponent((LayoutComponent)component);
        class_2561 relativeLabel = this.definition("relative", "");
        class_3545<Vec3<Double>, Vec3<Integer>> relativePos = this.createRelativePosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), new class_2338(spawnpoint.method_10263(), spawnpoint.method_10264(), spawnpoint.method_10260()));
        Triplet<String, String, String> relative = this.roundPosition((Vec3<Double>)((Vec3)relativePos.method_15442()), (Vec3<Integer>)((Vec3)relativePos.method_15441()), CoordinatesDisplay.getConfig().decimalPlaces);
        Triplet<class_2561, class_2561, class_2561> relativeXYZ = this.createXYZ((String)relative.getA(), (String)relative.getB(), (String)relative.getC());
        ParagraphComponent component2 = new ParagraphComponent(0, new class_2561[]{relativeLabel, (class_2561)relativeXYZ.getA(), (class_2561)relativeXYZ.getB(), (class_2561)relativeXYZ.getC()});
        row2.addComponent((LayoutComponent)component2);
        CompassRenderer compass = new CompassRenderer(pos, spawnpoint);
        row2.addComponent((LayoutComponent)compass);
        hud.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row1));
        hud.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row2));
        return new PaddingLayout(x, y, this.config().padding, (RenderingLayout)hud);
    }

    public static class CompassRenderer
    extends LayoutComponent<Position> {
        class_2338 spawnpoint;
        public int size = 32;

        public CompassRenderer(Position component, class_2338 spawnpoint) {
            super((Object)component);
            this.spawnpoint = spawnpoint;
        }

        public int getWidth() {
            return this.size;
        }

        public int getHeight() {
            return this.size;
        }

        public double calculateRelativeDirection(Vec3<Integer> pos1, Vec3<Integer> pos2, double yaw) {
            int x = (Integer)pos2.getX() - (Integer)pos1.getX();
            int z = (Integer)pos2.getZ() - (Integer)pos1.getZ();
            double theta = Math.atan2(z, x);
            double startDirection = Math.toDegrees(theta) + 180.0;
            double relativeDirection = startDirection - yaw;
            if (relativeDirection < 0.0) {
                relativeDirection += 360.0;
            }
            return class_3532.method_15338((double)((relativeDirection -= 180.0) - 90.0));
        }

        private class_2960 resolveCompassTexture(double d) {
            double degrees = class_3532.method_15338((double)(d + 180.0));
            double range360 = degrees + 180.0;
            double range1 = range360 / 360.0;
            String[] textures = new String[]{"compass_16", "compass_17", "compass_18", "compass_19", "compass_20", "compass_21", "compass_22", "compass_23", "compass_24", "compass_25", "compass_26", "compass_27", "compass_28", "compass_29", "compass_30", "compass_31", "compass_00", "compass_01", "compass_02", "compass_03", "compass_04", "compass_05", "compass_06", "compass_07", "compass_08", "compass_09", "compass_10", "compass_11", "compass_12", "compass_13", "compass_14", "compass_15", "compass_16"};
            String texture = "textures/item/" + textures[(int)(range1 * (double)textures.length)] + ".png";
            return class_2960.method_60656((String)texture);
        }

        public void render(class_332 guiGraphics, int x, int y) {
            double degrees = this.calculateRelativeDirection(((Position)this.component).position.getBlockPos(), (Vec3<Integer>)new Vec3((Number)this.spawnpoint.method_10263(), (Number)this.spawnpoint.method_10264(), (Number)this.spawnpoint.method_10260()), ((Position)this.component).headRot.wrapYaw());
            RenderUtils.drawTexture((class_2960)this.resolveCompassTexture(degrees), (class_332)guiGraphics, (int)x, (int)y, (int)this.size, (int)this.size, (int)0, (int)0);
        }
    }
}

