/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.mcshare;

import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.ModLogger;
import dev.boxadactle.mcshare.gui.WorldImportScreen;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.UUID;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8086;

public class MCShare {
    public static final String MOD_NAME = "MCShare";
    public static final String MOD_ID = "mcshare";
    public static final String MOD_VERSION = "1.0.0";
    public static final String VERSION_STRING = "MCShare v1.0.0";
    public static final ModLogger LOGGER = new ModLogger("MCShare");
    public static final int LIST_SHIFT = 30;
    public static final int BUTTONS_SIZE = 120;
    public static final int BUTTON_PADDING = 3;

    public static void init() {
        LOGGER.info((Object)"Sucessfully initialized %s", new Object[]{VERSION_STRING});
    }

    public static Path getWorldFolder() {
        return Path.of(ClientUtils.getClient().field_1697.getAbsolutePath(), "saves");
    }

    public static Path getTempFolder() {
        try {
            return Path.of(System.getProperty("java.io.tmpdir"), new String[0]).toAbsolutePath();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to get temp path", new Object[]{e});
            return Path.of(System.getProperty("user.home"), new String[0]);
        }
    }

    public static Path getDesktop() {
        try {
            return Path.of(System.getProperty("user.home"), "Desktop").toAbsolutePath();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to get desktop path", new Object[]{e});
            return Path.of(System.getProperty("user.home"), new String[0]);
        }
    }

    public static void rmrf(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    public static String generateImport() {
        return MOD_ID + UUID.randomUUID().toString().split("-")[0];
    }

    public static boolean isNewerVersion(String version) {
        String currentVersion = ClientUtils.getGameVersion();
        if (currentVersion == null || version == null) {
            return false;
        }
        String[] currentParts = currentVersion.split("\\.");
        String[] versionParts = version.split("\\.");
        for (int i = 0; i < Math.min(currentParts.length, versionParts.length); ++i) {
            int versionPart;
            int currentPart = Integer.parseInt(currentParts[i]);
            if (currentPart < (versionPart = Integer.parseInt(versionParts[i]))) {
                return true;
            }
            if (currentPart <= versionPart) continue;
            return false;
        }
        return currentParts.length < versionParts.length;
    }

    public static void encryption(ZipParameters parameters) {
        parameters.setEncryptFiles(true);
        parameters.setEncryptionMethod(EncryptionMethod.AES);
        parameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
    }

    public static class ImportTab
    extends class_8086 {
        class_437 parent;

        public ImportTab(class_437 parent) {
            super((class_2561)class_2561.method_43471((String)"screen.mcshare.importworld"));
            this.parent = parent;
            class_7845.class_7939 gridlayout$rowhelper = this.field_42139.method_48636(8).method_47610(1);
            gridlayout$rowhelper.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.mcshare.import"), this::openImportScreen).method_46432(210).method_46431());
        }

        private void openImportScreen(class_4185 b) {
            ClientUtils.setScreen((class_437)new WorldImportScreen(this.parent));
        }
    }
}

