/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.mcshare;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.mcshare.MCShare;
import dev.boxadactle.mcshare.Metadata;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;

public class WorldExporter {
    private static Path createMetadataFile(String folderName) {
        Metadata metadata = new Metadata(1, ClientUtils.getGameVersion(), folderName);
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson((Object)metadata);
        Path metadataPath = MCShare.getTempFolder().resolve("mcshare.metadata");
        try {
            Files.writeString(metadataPath, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MCShare.LOGGER.info((Object)("Created metadata file at " + metadataPath.toFile().getAbsolutePath()), new Object[0]);
        return metadataPath;
    }

    public static void startExport(ExportOptions options) {
        String generated = "mcshare_" + System.currentTimeMillis();
        Path metadata = WorldExporter.createMetadataFile(generated);
        try {
            MCShare.LOGGER.info((Object)"Creating zip...", new Object[0]);
            ZipFile zipFile = new ZipFile(options.exportPath.toFile(), options.password);
            ZipParameters parameters = new ZipParameters();
            parameters.setExcludeFileFilter(f -> {
                boolean bl = false;
                if (!options.includeResourcepacks) {
                    bl = f.toString().contains("resources.zip");
                }
                if (!options.includeDatapacks && !bl) {
                    bl = f.toString().contains("datapacks");
                }
                return bl;
            });
            ZipParameters metadataParameters = new ZipParameters();
            metadataParameters.setFileNameInZip("mcshare.metadata");
            if (options.password != null) {
                MCShare.encryption(parameters);
                MCShare.encryption(metadataParameters);
            }
            parameters.setRootFolderNameInZip(generated);
            for (File file : Objects.requireNonNull(options.worldPath.toFile().listFiles())) {
                if (file.isDirectory()) {
                    zipFile.addFolder(file, parameters);
                    continue;
                }
                zipFile.addFile(file, parameters);
            }
            zipFile.addFile(metadata.toFile(), metadataParameters);
            MCShare.LOGGER.info((Object)"Finished!", new Object[0]);
            options.finish.run();
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().contains("locked a portion of the file")) {
                MCShare.LOGGER.warn((Object)"File has been locked, either you are on windows or this is a bug!", new Object[0]);
                options.errored.accept("File has been locked, either Windows is being silly or this is a bug!");
            }
            MCShare.LOGGER.error((Object)"Error occurred when exporting!", new Object[0]);
            MCShare.LOGGER.printStackTrace(e);
            options.errored.accept(e.getMessage());
        }
        try {
            Files.deleteIfExists(metadata);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class ExportOptions {
        Path exportPath;
        Path worldPath;
        boolean includeDatapacks;
        boolean includeResourcepacks;
        Runnable finish;
        Consumer<String> errored;
        char[] password = null;

        public ExportOptions setExportPath(Path exportPath) {
            if (!exportPath.endsWith(".mcshare")) {
                exportPath = exportPath.resolveSibling(String.valueOf(exportPath.getFileName()) + ".mcshare");
            }
            this.exportPath = exportPath;
            return this;
        }

        public ExportOptions setWorldPath(Path worldPath) {
            this.worldPath = worldPath;
            return this;
        }

        public ExportOptions setIncludeResourcepacks(boolean includeResourcepacks) {
            this.includeResourcepacks = includeResourcepacks;
            return this;
        }

        public ExportOptions setIncludeDatapacks(boolean includeDatapacks) {
            this.includeDatapacks = includeDatapacks;
            return this;
        }

        public ExportOptions setFinished(Runnable finish) {
            this.finish = finish;
            return this;
        }

        public ExportOptions setErrored(Consumer<String> errored) {
            this.errored = errored;
            return this;
        }

        public ExportOptions setPassword(String password) {
            if (password == null || password.isBlank()) {
                this.password = null;
                return this;
            }
            this.password = password.toCharArray();
            return this;
        }
    }
}

