/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.mcshare.gui;

import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.BSpacingEntry;
import dev.boxadactle.boxlib.gui.config.widget.field.BStringField;
import dev.boxadactle.boxlib.gui.config.widget.label.BCenteredLabel;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.mcshare.MCShare;
import dev.boxadactle.mcshare.WorldImporter;
import dev.boxadactle.mcshare.gui.PathField;
import dev.boxadactle.mcshare.mixin.CreateWorldParentAccessor;
import dev.boxadactle.mcshare.mixin.SelectWorldParentAccessor;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_424;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_525;
import net.minecraft.class_526;

public class WorldImportScreen
extends BOptionScreen {
    class_4185 confirm;
    Path path = MCShare.getDesktop();
    PathField field;
    String password = null;

    public WorldImportScreen(class_437 parent) {
        super(parent);
    }

    protected class_2561 getName() {
        return class_2561.method_43473();
    }

    protected void initFooter(int i, int i1) {
        int number = this.getButtonWidth(BOptionHelper.ButtonType.SMALL);
        this.confirm = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.mcshare.import.screen"), this::startImport).method_46434(this.field_22789 / 2 - number - 1, this.field_22790 - 25, number, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)GuiUtils.CANCEL, b -> this.method_25419()).method_46434(this.field_22789 / 2 + 1, this.field_22790 - 25, number, 20).method_46431());
    }

    protected void initConfigButtons() {
        this.addConfigLine((BOptionEntry)new BCenteredLabel((class_2561)class_2561.method_43471((String)"screen.mcshare.importworld")));
        this.addConfigLine((BOptionEntry)new BCenteredLabel((class_2561)class_2561.method_43471((String)"label.mcshare.dragging")));
        this.space();
        this.field = new PathField(this.path, v -> {
            this.path = v;
        });
        this.field.method_1880(512);
        this.addConfigLine((BOptionEntry)this.field);
        this.addConfigLine((BOptionEntry)new BSpacingEntry());
        this.addConfigLine((BOptionEntry)new BCenteredLabel((class_2561)class_2561.method_43471((String)"label.mcshare.password")));
        this.addConfigLine((BOptionEntry)new BStringField("", s -> {
            this.password = s;
        }));
    }

    public void method_29638(List<Path> list) {
        for (Path p : list) {
            if (!p.toString().endsWith(".mcshare") && !p.toString().endsWith(".zip")) continue;
            this.path = p;
            this.field.method_1852(this.field.from(p));
            this.field.valid();
            break;
        }
    }

    private void space() {
        this.addConfigLine((BOptionEntry)new BSpacingEntry());
    }

    private void startImport(class_4185 b) {
        ClientUtils.getClient().method_29970((class_437)new ImportingScreen(this.parent, this.path.getFileName().toString()));
        WorldImporter.ImportOptions options = new WorldImporter.ImportOptions().setPath(this.path).setPassword(this.password.isEmpty() ? null : this.password).setFinished(() -> ((ImportingScreen)ClientUtils.getClient().field_1755).setFinished()).setErrored(s -> ((ImportingScreen)ClientUtils.getClient().field_1755).setErrored((String)s));
        WorldImporter.startImport(options);
    }

    public static class ImportingScreen
    extends class_437 {
        class_437 parent;
        boolean isFinished = false;
        boolean isError = false;
        String error;
        String worldName;
        class_4185 doneButton;
        class_4185 playButton;
        List<String> worldFiles;

        protected ImportingScreen(class_437 parent, String name) {
            super((class_2561)class_2561.method_43469((String)"screen.mcshare.importing", (Object[])new Object[]{name}));
            this.worldName = name;
            this.parent = parent;
            Path worldFolder = MCShare.getWorldFolder();
            this.worldFiles = List.of(worldFolder.toFile().list((dir, name1) -> dir.isDirectory()));
        }

        public void method_25394(class_332 guiGraphics, int i, int j, float f) {
            super.method_25394(guiGraphics, i, j, f);
            if (!this.isError) {
                guiGraphics.method_27534(this.field_22793, (class_2561)(this.isFinished ? class_2561.method_43471((String)"message.mcshare.finished.import") : this.field_22785), this.field_22789 / 2, this.field_22790 / 2 - 60, 0xFFFFFF);
            } else {
                guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"message.mcshare.finished.import.error"), this.field_22789 / 2, this.field_22790 / 2 - 60, 0xFFFFFF);
                guiGraphics.method_25300(this.field_22793, this.error.trim(), this.field_22789, this.field_22790 / 2 - 45, 0xAA0000);
            }
        }

        protected void method_25426() {
            int number = BOptionHelper.buttonWidth((BOptionHelper.ButtonType)BOptionHelper.ButtonType.SMALL);
            this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)GuiUtils.DONE, b -> this.method_25419()).method_46434(this.field_22789 / 2 - number - 1, this.field_22790 - 40, number, 20).method_46431());
            this.playButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.mcshare.play"), this::playWorld).method_46434(this.field_22789 / 2 + 1, this.field_22790 - 40, number, 20).method_46431());
            this.doneButton.field_22764 = false;
            this.doneButton.field_22763 = false;
            this.playButton.field_22764 = false;
            this.playButton.field_22763 = false;
        }

        private void playWorld(class_4185 button) {
            Path worldFolder = MCShare.getWorldFolder();
            for (String file : worldFolder.toFile().list((dir, name1) -> dir.isDirectory())) {
                if (this.worldFiles.contains(file)) continue;
                this.field_22787.method_29970((class_437)new class_424((class_2561)class_2561.method_43471((String)"message.mcshare.open")));
                this.field_22787.method_41735().method_41894((class_437)this, this.worldName.replace(".mcshare", ""));
                break;
            }
            ClientUtils.setScreen((class_437)new class_526((class_437)new class_442()));
            ClientUtils.showToast((class_2561)class_2561.method_43471((String)"message.mcshare.open.error"), (class_2561)class_2561.method_43471((String)"message.mcshare.open.error.2"));
        }

        public void setFinished() {
            this.isFinished = true;
            this.activateButtons(true);
        }

        public void setErrored(String errorMessage) {
            this.isError = true;
            this.error = errorMessage;
            this.activateButtons(false);
        }

        private void activateButtons(boolean bl) {
            this.doneButton.field_22764 = true;
            this.playButton.field_22764 = true;
            this.doneButton.field_22763 = true;
            this.playButton.field_22763 = bl;
            MCShare.LOGGER.info((Object)"ImportingScreen buttons activated", new Object[0]);
        }

        public boolean method_25422() {
            return this.isFinished || this.isError;
        }

        public void method_25419() {
            if (this.parent instanceof class_526) {
                this.field_22787.method_1507((class_437)new class_526(((SelectWorldParentAccessor)this.parent).getParent()));
            } else if (this.parent instanceof class_525) {
                this.field_22787.method_1507((class_437)new class_526(((CreateWorldParentAccessor)this.parent).getParent()));
            } else {
                MCShare.LOGGER.error((Object)"Parent was not an instance of {} or {}", new Object[]{class_526.class, class_525.class});
                this.field_22787.method_1507((class_437)new class_442());
            }
        }
    }
}

