/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.gui;

import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.math.geometry.Dimension;
import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.math.geometry.Vec2;
import dev.boxadactle.boxlib.math.mathutils.Clamps;
import dev.boxadactle.boxlib.prompt.Prompts;
import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.Hud;
import dev.boxadactle.coordinatesdisplay.ModConfig;
import dev.boxadactle.coordinatesdisplay.gui.HudHelper;
import dev.boxadactle.coordinatesdisplay.position.Position;
import dev.boxadactle.coordinatesdisplay.registry.StartCorner;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import org.joml.Matrix3x2fStack;

public class PositionScreen
extends BOptionScreen
implements HudHelper {
    int x;
    int y;
    float scale;
    int hudOffsetX;
    int hudOffsetY;
    boolean clickDelta = false;
    boolean scaleDelta = false;
    boolean moveDelta = false;
    Position pos = WorldUtils.getWorld() != null ? Position.of(WorldUtils.getPlayer()) : this.generatePositionData();
    boolean isDragging = false;

    public PositionScreen(class_437 parent) {
        super(parent, (class_2561)class_2561.method_43471((String)"screen.coordinatesdispaly.hudposition"));
        CoordinatesDisplay.shouldHudRender = false;
    }

    protected void method_25426() {
        super.method_25426();
        if (!this.config().renderMode.getMetadata().allowMove()) {
            CoordinatesDisplay.LOGGER.error((Object)("Cannot open the position screen when the render mode is set to " + String.valueOf((Object)this.config().renderMode)), new Object[0]);
            Prompts.alert((class_437)this.field_21335, (class_2561)class_2561.method_43469((String)"message.coordinatesdisplay.movehud.error", (Object[])new Object[]{this.config().renderMode.getComponent()}));
            CoordinatesDisplay.shouldHudRender = true;
        }
        Rect hud = CoordinatesDisplay.HUD.preRender(Hud.RenderType.SCREEN, this.pos, this.config().hudX, this.config().hudY, this.config().renderMode, this.config().startCorner).calculateRect();
        this.x = (Integer)hud.getX();
        this.y = (Integer)hud.getY();
        this.scale = ((ModConfig)CoordinatesDisplay.CONFIG.get()).hudScale;
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        if (this.moveHud(i, j)) {
            Rect rect = Clamps.clampRect((int)this.x, (int)this.y, (int)CoordinatesDisplay.HUD.getWidth(), (int)CoordinatesDisplay.HUD.getHeight(), (int)0, (int)0, (int)Math.round((float)this.field_22789 / this.scale), (int)Math.round((float)this.field_22790 / this.scale));
            this.x = (Integer)rect.getX();
            this.y = (Integer)rect.getY();
        }
        CoordinatesDisplay.HUD.render(guiGraphics, Hud.RenderType.SCREEN, this.pos, this.x, this.y, this.config().renderMode, StartCorner.TOP_LEFT, this.scale);
        if (CoordinatesDisplay.HUD.isHovered(i, j)) {
            Matrix3x2fStack stack = guiGraphics.method_51448();
            stack.pushMatrix();
            stack.scale(this.scale, this.scale);
            CoordinatesDisplay.HUD.renderMoveOverlay(guiGraphics, this.x, this.y);
            stack.popMatrix();
        }
    }

    public boolean moveHud(int mouseX, int mouseY) {
        if (this.isDragging) {
            if (!this.clickDelta) {
                this.clickDelta = true;
                if (CoordinatesDisplay.HUD.isScaleButtonHovered(mouseX, mouseY)) {
                    this.scaleDelta = true;
                    this.hudOffsetX = Math.round((float)this.x * this.scale);
                    this.hudOffsetY = Math.round((float)this.y * this.scale);
                } else {
                    this.moveDelta = true;
                    Dimension<Integer> offset = this.getDistance((Vec2<Integer>)new Vec2((Number)Math.round((float)mouseX / this.scale), (Number)Math.round((float)mouseY / this.scale)), (Vec2<Integer>)new Vec2((Number)this.x, (Number)this.y));
                    this.hudOffsetX = (Integer)offset.getWidth();
                    this.hudOffsetY = (Integer)offset.getHeight();
                }
            }
            if (this.scaleDelta) {
                this.scale = CoordinatesDisplay.HUD.calculateScale(this.hudOffsetX, this.hudOffsetY, mouseX, mouseY);
                this.x = Math.round((float)this.hudOffsetX / this.scale);
                this.y = Math.round((float)this.hudOffsetY / this.scale);
            } else {
                this.x = Math.round((float)mouseX / this.scale) - this.hudOffsetX;
                this.y = Math.round((float)mouseY / this.scale) - this.hudOffsetY;
            }
            return true;
        }
        if (this.clickDelta) {
            this.clickDelta = false;
            this.scaleDelta = false;
            this.moveDelta = false;
        }
        return false;
    }

    protected boolean shouldRenderScrollingWidget() {
        return false;
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        this.isDragging = true;
        return super.method_25402(event, isDoubleClick);
    }

    public boolean method_25406(class_11909 event) {
        this.isDragging = false;
        return super.method_25406(event);
    }

    public void method_25419() {
        super.method_25419();
        Vec2<Integer> translated = this.config().startCorner.getModifier().getRelativePos((Rect<Integer>)new Rect((Number)this.x, (Number)this.y, (Number)CoordinatesDisplay.HUD.getWidth(), (Number)CoordinatesDisplay.HUD.getHeight()), (Dimension<Integer>)new Dimension((Number)Math.round((float)this.field_22789 / this.scale), (Number)Math.round((float)this.field_22790 / this.scale)));
        this.config().hudX = (Integer)translated.getX();
        this.config().hudY = (Integer)translated.getY();
        this.config().hudScale = this.scale;
        if (WorldUtils.getWorld() != null) {
            CoordinatesDisplay.CONFIG.save();
        }
        CoordinatesDisplay.shouldHudRender = true;
    }

    protected void initFooter(class_8667 layout) {
        layout.method_52736((class_8021)this.createSaveButton(b -> this.method_25419()));
    }

    protected void method_60325() {
    }

    public boolean method_25422() {
        return false;
    }

    private Dimension<Integer> getDistance(Vec2<Integer> vec1, Vec2<Integer> vec2) {
        int distanceX = (Integer)vec1.getX() - (Integer)vec2.getX();
        int distanceY = (Integer)vec1.getY() - (Integer)vec2.getY();
        return new Dimension((Number)distanceX, (Number)distanceY);
    }
}

