/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.position;

import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class PlayerWorldData {
    class_2960 dimension;
    class_6880<class_1959> biome;
    long day;
    long time;

    public PlayerWorldData(class_2338 player) {
        if (WorldUtils.getWorld() != null) {
            this.dimension = WorldUtils.getPlayer().method_73183().method_27983().method_29177();
            this.biome = WorldUtils.getWorld().method_23753(player);
            this.day = WorldUtils.getWorld().method_8532() / 24000L;
            this.time = WorldUtils.getWorld().method_8510() % 24000L;
        } else {
            CoordinatesDisplay.LOGGER.warn((Object)"Client world is null! Resorting to default values.", new Object[0]);
            this.dimension = class_2960.method_60656((String)"overworld");
            this.day = Math.round(Math.random() * 1000.0);
            this.time = Math.round(Math.random() * 24000.0);
        }
    }

    public long getDay() {
        return this.day;
    }

    public long getTime() {
        return this.time;
    }

    private String formatName(String orig) {
        StringBuilder name = new StringBuilder();
        for (String word : orig.split("_")) {
            name.append(word.substring(0, 1).toUpperCase()).append(word.substring(1)).append(" ");
        }
        return name.toString().trim();
    }

    public String getDimension(boolean formatted) {
        return formatted ? this.formatName(this.dimension.method_12832()) : this.dimension.toString();
    }

    public class_1959 getBiome() {
        if (this.biome != null) {
            return (class_1959)this.biome.comp_349();
        }
        return null;
    }

    public class_2960 getBiomeKey() {
        class_2960 def = class_2960.method_60656((String)"plains");
        if (this.biome == null) {
            return def;
        }
        return (class_2960)this.biome.method_40229().map(class_5321::method_29177, biome -> def);
    }
}

