/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.math.geometry.Vec2;
import dev.boxadactle.boxlib.math.mathutils.NumberFormatter;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.WorldColors;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import oshi.util.tuples.Triplet;

@HudDisplayMode(value="default")
public class DefaultRenderer
implements HudRenderer {
    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        NumberFormatter<Double> formatter = this.genFormatter();
        Triplet<String, String, String> player = this.roundPosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), CoordinatesDisplay.getConfig().decimalPlaces);
        Vec2<Integer> chunkPos = pos.position.getChunkPos();
        int p = this.config().padding;
        int tp = this.config().textPadding;
        ColumnLayout hud = new ColumnLayout(0, 0, tp);
        RowLayout row1 = new RowLayout(0, 0, tp);
        ParagraphComponent row2 = new ParagraphComponent(0, new class_2561[0]);
        if (this.config().renderXYZ) {
            class_2561 xtext = this.definition(HudRenderer.GlobalTexts.X, this.value((String)player.getA()));
            class_2561 ytext = this.definition(HudRenderer.GlobalTexts.Y, this.value((String)player.getB()));
            class_2561 ztext = this.definition(HudRenderer.GlobalTexts.Z, this.value((String)player.getC()));
            row1.addComponent((LayoutComponent)new ParagraphComponent(0, new class_2561[]{xtext, ytext, ztext}));
        }
        if (this.config().renderChunkData) {
            class_2561 chunkx = this.definition(HudRenderer.GlobalTexts.CHUNK_X, this.value(((Integer)chunkPos.getX()).toString()));
            class_2561 chunkz = this.definition(HudRenderer.GlobalTexts.CHUNK_Z, this.value(((Integer)chunkPos.getY()).toString()));
            row1.addComponent((LayoutComponent)new ParagraphComponent(0, new class_2561[]{chunkx, chunkz}));
        }
        if (this.config().renderDirection) {
            class_5250 direction = class_2561.method_43473().method_10852(this.definition(this.resolveDirection(ModUtil.getDirectionFromYaw(pos.headRot.wrapYaw())))).method_27693(" ").method_10852((class_2561)(this.config().renderDirectionInt ? this.value("(" + formatter.formatDecimal((Number)pos.headRot.wrapYaw()) + ")") : class_2561.method_43473()));
            row2.add((class_2561)direction);
        }
        if (this.config().renderBiome || this.config().renderDimension) {
            class_2561 biomeString = ModUtil.getBiomeComponent(pos.world.getBiomeKey(), pos.world.getBiome(), this.config().biomeColors, this.config().dataColor);
            class_2561 biome = this.definition(HudRenderer.GlobalTexts.BIOME, biomeString);
            String dimensionstring = pos.world.getDimension(true);
            class_2561 coloredDimensionstring = GuiUtils.colorize((class_2561)class_2561.method_43470((String)dimensionstring), (int)(this.config().biomeColors ? WorldColors.getDimensionColor(dimensionstring, this.config().definitionColor) : this.config().definitionColor));
            class_2561 dimension = this.definition(HudRenderer.GlobalTexts.DIMENSION, coloredDimensionstring);
            class_5250 biomeDimension = (this.config().renderDimension ? (this.config().renderBiome ? coloredDimensionstring : dimension).method_27661() : class_2561.method_43473()).method_10852((class_2561)(this.config().renderDimension && this.config().renderBiome ? this.definition(": ") : class_2561.method_43473())).method_10852((class_2561)(this.config().renderBiome ? (this.config().renderDimension ? biomeString : biome) : class_2561.method_43473()));
            row2.add((class_2561)biomeDimension);
        }
        if (this.config().renderMCVersion) {
            class_2561 mcversion = this.definition("version", this.value(ClientUtils.getGameVersion()));
            row2.add(mcversion);
        }
        if (this.config().renderDay) {
            class_2561 day = this.definition(HudRenderer.GlobalTexts.DAY, this.value(Long.toString(pos.world.getDay())));
            row2.add(day);
        }
        hud.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row1));
        hud.addComponent((LayoutComponent)row2);
        return new PaddingLayout(x, y, p, (RenderingLayout)hud);
    }
}

