/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.marking;

import com.google.common.collect.ImmutableList;
import dev.boxadactle.boxlib.gui.config.BConfigList;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.BSpacingEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BCustomButton;
import dev.boxadactle.boxlib.gui.config.widget.label.BCenteredLabel;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.marking.MarkSerializer;
import dev.boxadactle.coordinatesdisplay.marking.PlaceholderIntegerField;
import dev.boxadactle.coordinatesdisplay.position.Position;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class MarkGui
extends BOptionScreen {
    int x;
    int y;
    int z;
    Position pos = Position.of(WorldUtils.getPlayer());
    BCustomButton b;
    BCustomButton s;

    public MarkGui() {
        super(null, (Component)Component.translatable((String)"screen.coordinatesdisplay.mark"));
        this.x = (Integer)this.pos.position.getBlockPos().getX();
        this.y = (Integer)this.pos.position.getBlockPos().getY();
        this.z = (Integer)this.pos.position.getBlockPos().getZ();
    }

    protected void initFooter(LinearLayout linearLayout) {
        linearLayout.addChild((LayoutElement)this.createDoneButton(this.lastScreen));
    }

    public void tick() {
        this.b.active = CoordinatesDisplay.MARK_POS != null;
        this.s.active = CoordinatesDisplay.MARK_POS != null;
    }

    protected void addOptions() {
        this.addConfigLine((BOptionEntry)new BCenteredLabel((Component)Component.translatable((String)"label.coordinatesdisplay.markPos")));
        this.addConfigLine(new TripleEntry((BOptionEntry<?>)new BCenteredLabel((Component)Component.literal((String)"X: ")), (BOptionEntry<?>)new BCenteredLabel((Component)Component.literal((String)"Y: ")), (BOptionEntry<?>)new BCenteredLabel((Component)Component.literal((String)"Z: "))));
        this.addConfigLine(new TripleEntry((BOptionEntry<?>)new PlaceholderIntegerField(v -> {
            this.x = v;
        }, this.x), (BOptionEntry<?>)new PlaceholderIntegerField(v -> {
            this.y = v;
        }, this.y), (BOptionEntry<?>)new PlaceholderIntegerField(v -> {
            this.z = v;
        }, this.z)));
        this.b = BCustomButton.create((Component)Component.translatable((String)"button.coordinatesdisplay.clearMarked"), () -> {
            CoordinatesDisplay.MARK_POS = null;
        });
        this.addConfigLine((BOptionEntry)this.b, (BOptionEntry)BCustomButton.create((Component)Component.translatable((String)"button.coordinatesdisplay.mark"), () -> {
            CoordinatesDisplay.MARK_POS = new Vec3((Number)this.x, (Number)this.y, (Number)this.z);
            CoordinatesDisplay.LOGGER.player.info(I18n.get((String)"command.coordinatesdisplay.mark", (Object[])new Object[]{this.x, this.y, this.z}), new Object[0]);
        }));
        this.addConfigLine((BOptionEntry)new BSpacingEntry());
        this.s = (BCustomButton)this.addConfigLine((BOptionEntry)BCustomButton.create((Component)Component.translatable((String)"button.coordinatesdisplay.shareMark"), () -> ClientUtils.confirm((Component)Component.translatable((String)"message.coordinatesdisplay.mark.shared.confirm"), (Component)Component.translatable((String)"message.coordinatesdisplay.mark.shared.confirm2"), () -> {
            CoordinatesDisplay.LOGGER.player.publicChat(MarkSerializer.serialize(CoordinatesDisplay.MARK_POS));
            ClientUtils.setScreen(null);
        }, () -> ClientUtils.setScreen(null))));
    }

    public static class TripleEntry
    extends BConfigList.ConfigEntry {
        BOptionEntry<?> widget1;
        BOptionEntry<?> widget2;
        BOptionEntry<?> widget3;

        public TripleEntry(BOptionEntry<?> widget1, BOptionEntry<?> widget2, BOptionEntry<?> widget3) {
            this.widget1 = widget1;
            this.widget2 = widget2;
            this.widget3 = widget3;
        }

        public List<? extends AbstractWidget> getWidgets() {
            return ImmutableList.of((Object)((AbstractWidget)this.widget1), (Object)((AbstractWidget)this.widget2), (Object)((AbstractWidget)this.widget3));
        }

        public boolean isInvalid() {
            return this.widget1.isInvalid() || this.widget2.isInvalid();
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float v) {
            AbstractWidget w1 = (AbstractWidget)this.widget1;
            AbstractWidget w2 = (AbstractWidget)this.widget2;
            AbstractWidget w3 = (AbstractWidget)this.widget3;
            int p1 = BOptionHelper.padding() / 2;
            int p2 = BOptionHelper.padding() / 2;
            w1.setX(this.getX());
            w1.setY(this.getY());
            w1.setWidth(this.getWidth() / 3 - p1);
            w2.setX(this.getX() + this.getWidth() / 3 + p2);
            w2.setY(this.getY());
            w2.setWidth(this.getWidth() / 3 - p2);
            w3.setX(this.getX() + 2 * (this.getWidth() / 3) + p1);
            w3.setY(this.getY());
            w3.setWidth(this.getWidth() / 3 - p1);
            w1.render(guiGraphics, mouseX, mouseY, v);
            w2.render(guiGraphics, mouseX, mouseY, v);
            w3.render(guiGraphics, mouseX, mouseY, v);
        }
    }
}

