/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.mixin;

import com.google.gson.stream.MalformedJsonException;
import com.mojang.authlib.GameProfile;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.marking.MarkSerializer;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.PlayerChatMessage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatListener.class})
public class ChatListenerMixin {
    @Inject(method={"handlePlayerChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkMessages(PlayerChatMessage chatMessage, GameProfile gameProfile, ChatType.Bound boundChatType, CallbackInfo ci) {
        try {
            Vec3<Integer> mark = MarkSerializer.deserialize(chatMessage.decoratedContent().getString());
            ci.cancel();
            CoordinatesDisplay.LOGGER.player.chat(ModUtil.makeMarkComponent(mark, gameProfile.name()));
        }
        catch (MalformedJsonException malformedJsonException) {
            // empty catch block
        }
    }
}

