/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.math.geometry.Vec2;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.boxlib.math.mathutils.NumberFormatter;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.network.chat.Component;

@HudDisplayMode(value="maximum")
public class MaxRenderer
implements HudRenderer {
    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        NumberFormatter<Double> formatter = this.genFormatter();
        ParagraphComponent component = new ParagraphComponent(this.config().textPadding, new Component[0]);
        if (this.config().renderXYZ) {
            Vec3<Double> b = pos.position.getPlayerPos();
            Vec3<Integer> d = pos.position.getBlockPos();
            Vec3<Integer> e = pos.position.getBlockPosInChunk();
            Component xyz = this.definition(HudRenderer.GlobalTexts.XYZ, this.value(formatter.formatDecimal((Number)((Double)b.getX()))), this.value(formatter.formatDecimal((Number)((Double)b.getY()))), this.value(formatter.formatDecimal((Number)((Double)b.getZ()))));
            Component block = this.definition(this.translation("block", this.value(Integer.toString((Integer)d.getX())), this.value(Integer.toString((Integer)d.getY())), this.value(Integer.toString((Integer)d.getZ())), this.value(Integer.toString((Integer)e.getX())), this.value(Integer.toString((Integer)e.getY())), this.value(Integer.toString((Integer)e.getZ()))));
            Component targeted = this.definition(this.translation("block.targeted", this.value(pos.block.getBlockX()), this.value(pos.block.getBlockY()), this.value(pos.block.getBlockZ())));
            component.add(xyz);
            component.add(block);
            component.add(targeted);
        }
        if (this.config().renderChunkData) {
            Vec2<Integer> c = pos.position.getChunkPos();
            Component chunk = this.definition(this.translation("chunk", this.value(Integer.toString((Integer)c.getX())), this.value(Integer.toString(pos.position.getChunkY())), this.value(Integer.toString((Integer)c.getY()))));
            component.add(chunk);
        }
        if (this.config().renderDirection) {
            Component f = this.definition("direction_int", this.value(formatter.formatDecimal((Number)pos.headRot.wrapYaw())), this.value(formatter.formatDecimal((Number)pos.headRot.wrapPitch())));
            Component g = this.definition(this.resolveDirection(ModUtil.getDirectionFromYaw(pos.headRot.wrapYaw())));
            Component direction = this.definition(this.translation("direction", g, this.config().renderDirectionInt ? f : Component.empty()));
            component.add(direction);
        }
        if (this.config().renderBiome) {
            Component biome = this.definition(this.translation("biome", this.value(pos.world.getBiomeKey().toString())));
            component.add(biome);
        }
        if (this.config().renderMCVersion) {
            Component version = this.definition(this.translation("version", this.value(ClientUtils.getGameVersion())));
            component.add(version);
        }
        if (this.config().renderDimension) {
            String h = pos.world.getDimension(true);
            String i = pos.world.getDimension(false);
            Component dimension = this.definition(this.translation("dimension", this.value(h), this.value(ModUtil.getNamespace(i))));
            component.add(dimension);
        }
        if (this.config().renderDay) {
            Component day = this.definition(HudRenderer.GlobalTexts.DAY, this.value(Long.toString(pos.world.getDay())));
            component.add(day);
        }
        RowLayout r = new RowLayout(0, 0, 0);
        r.addComponent((LayoutComponent)component);
        return new PaddingLayout(x, y, this.config().padding, (RenderingLayout)r);
    }
}

