/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.LeftParagraphComponent;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.network.chat.Component;
import oshi.util.tuples.Triplet;

@HudDisplayMode(value="minimum", hasXYZ=false, hasChunkData=false, hasDirectionInt=false, hasMCVersion=false, hasDimension=false, hasDay=false)
public class MinRenderer
implements HudRenderer {
    private Component[] createDirectionComponents(double yaw) {
        String[][] directions = new String[][]{{" ", "+"}, {"-", "+"}, {"-", " "}, {"-", "-"}, {" ", "-"}, {"+", "-"}, {"+", " "}, {"+", "+"}};
        String[] direction = directions[(int)Math.round(yaw / 45.0) & 7];
        return new Component[]{Component.literal((String)direction[0]), this.resolveDirection(ModUtil.getDirectionFromYaw(yaw), true), Component.literal((String)direction[1])};
    }

    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        Triplet<String, String, String> player = this.roundPosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), CoordinatesDisplay.getConfig().decimalPlaces);
        RowLayout layout = new RowLayout(0, 0, this.config().textPadding);
        ColumnLayout row = new ColumnLayout(0, 0, this.config().textPadding / 2);
        Component xtext = this.definition(HudRenderer.GlobalTexts.X, this.value((String)player.getA()));
        Component ytext = this.definition(HudRenderer.GlobalTexts.Y, this.value((String)player.getB()));
        Component ztext = this.definition(HudRenderer.GlobalTexts.Z, this.value((String)player.getC()));
        ParagraphComponent paragraph = new ParagraphComponent(1, new Component[]{xtext, ytext, ztext});
        row.addComponent((LayoutComponent)paragraph);
        if (this.config().renderBiome) {
            Component biome = ModUtil.getBiomeComponent(pos.world.getBiomeKey(), pos.world.getBiome(), this.config().biomeColors, this.config().definitionColor);
            row.addComponent((LayoutComponent)new TextComponent(biome));
        }
        layout.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row));
        if (this.config().renderDirection) {
            Component[] directionTexts = this.createDirectionComponents(pos.headRot.wrapYaw());
            Component xDirection = this.definition(directionTexts[0]);
            Component directionText = this.value(directionTexts[1]);
            Component zDirection = this.definition(directionTexts[2]);
            layout.addComponent((LayoutComponent)new LeftParagraphComponent(1, new Component[]{xDirection, directionText, zDirection}));
        }
        return new PaddingLayout(x, y, this.config().padding, (RenderingLayout)layout);
    }
}

