/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.math.mathutils.NumberFormatter;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.position.Position;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import oshi.util.tuples.Triplet;

@HudDisplayMode(value="nether_overworld", hasXYZ=false, hasChunkData=false, hasDirection=false, hasDirectionInt=false, hasBiome=false, hasMCVersion=false, hasDimension=false, hasDay=false)
public class NetherOverworldRenderer
implements HudRenderer {
    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        try {
            ColumnLayout hud = new ColumnLayout(0, 0, this.config().textPadding);
            Component overworld = this.definition(this.translation("overworld", new Object[0]));
            Component nether = this.definition(this.translation("nether", new Object[0]));
            NumberFormatter<Double> formatter = this.genFormatter();
            Component[][] coords = Objects.requireNonNull(this.createXYZs(Dimension.toDimension(pos.world.getDimension(false)), formatter, pos));
            RowLayout coordsLayout = new RowLayout(0, 0, this.config().textPadding);
            ParagraphComponent overworldCoords = new ParagraphComponent(1, new Component[0]);
            overworldCoords.add(overworld);
            ((List)overworldCoords.getComponent()).addAll(List.of(coords[0]));
            ParagraphComponent netherCoords = new ParagraphComponent(1, new Component[0]);
            netherCoords.add(nether);
            ((List)netherCoords.getComponent()).addAll(List.of(coords[1]));
            coordsLayout.addComponent((LayoutComponent)overworldCoords);
            coordsLayout.addComponent((LayoutComponent)netherCoords);
            Component dimensionText = this.value(pos.world.getDimension(true));
            TextComponent dimensionComponent = new TextComponent(dimensionText);
            hud.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)coordsLayout));
            hud.addComponent((LayoutComponent)dimensionComponent);
            return new PaddingLayout(x, y, this.config().padding, (RenderingLayout)hud);
        }
        catch (NullPointerException ignored) {
            Component error = GuiUtils.colorize((Component)this.translation("error", new Object[0]), (int)GuiUtils.RED);
            Component dimensionText = this.definition(HudRenderer.GlobalTexts.DIMENSION, this.value(pos.world.getDimension(true)));
            ColumnLayout hud = new ColumnLayout(0, 0, this.config().textPadding);
            hud.addComponent((LayoutComponent)new TextComponent(error));
            hud.addComponent((LayoutComponent)new TextComponent(dimensionText));
            return new PaddingLayout(x, y, this.config().padding, (RenderingLayout)hud);
        }
    }

    private Component[] createXYZComponents(String x, String y, String z) {
        return new Component[]{this.definition(HudRenderer.GlobalTexts.X, this.value(x)), this.definition(HudRenderer.GlobalTexts.Y, this.value(y)), this.definition(HudRenderer.GlobalTexts.Z, this.value(z))};
    }

    private Component[][] createXYZs(Dimension type, NumberFormatter<Double> d, Position pos) {
        Triplet<String, String, String> player = this.roundPosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), CoordinatesDisplay.getConfig().decimalPlaces);
        if (Objects.requireNonNull(type) == Dimension.OVERWORLD) {
            return new Component[][]{this.createXYZComponents((String)player.getA(), (String)player.getB(), (String)player.getC()), this.createXYZComponents(d.formatDecimal((Number)((Double)pos.position.getPlayerPos().getX() / 8.0)), "-", d.formatDecimal((Number)((Double)pos.position.getPlayerPos().getZ() / 8.0)))};
        }
        if (Objects.requireNonNull(type) == Dimension.NETHER) {
            return new Component[][]{this.createXYZComponents(d.formatDecimal((Number)((Double)pos.position.getPlayerPos().getX() * 8.0)), "-", d.formatDecimal((Number)((Double)pos.position.getPlayerPos().getZ() * 8.0))), this.createXYZComponents((String)player.getA(), (String)player.getB(), (String)player.getC())};
        }
        return null;
    }

    private static enum Dimension {
        OVERWORLD,
        NETHER;


        public static Dimension toDimension(String d) {
            if (d.toLowerCase().contains("overworld")) {
                return OVERWORLD;
            }
            if (d.toLowerCase().contains("nether")) {
                return NETHER;
            }
            return null;
        }
    }
}

