/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay;

import java.awt.Color;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class WorldColors {
    public static int getBiomeColor(ResourceLocation key, Biome biome) {
        if (biome == null) {
            return 2407431;
        }
        String biomeName = key.getPath().toLowerCase();
        if (biomeName.contains("end")) {
            return 12959371;
        }
        if (biomeName.contains("ocean") || biomeName.contains("river") || biomeName.contains("swamp")) {
            return biome.getWaterColor();
        }
        if (biomeName.contains("nether")) {
            return new Color(biome.getFogColor()).brighter().brighter().getRGB();
        }
        if (biomeName.contains("icy")) {
            return 8711408;
        }
        if (biomeName.contains("beach")) {
            return 16440917;
        }
        return biome.getFoliageColor();
    }

    public static int getDimensionColor(String name, int defaultColor) {
        return switch (name.toLowerCase()) {
            case "overworld" -> 65280;
            case "nether" -> 0xFF0000;
            case "end" -> 12959371;
            default -> name.startsWith("The ") ? WorldColors.getDimensionColor(name.substring(4), defaultColor) : defaultColor;
        };
    }
}

