/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.neoforge;

import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.Bindings;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.gui.ConfigScreen;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="coordinatesdisplay")
public class CoordinatesDisplayNeoforge {
    public static boolean deltaError = false;

    public CoordinatesDisplayNeoforge() {
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (minecraft, screen) -> new ConfigScreen(screen));
    }

    @EventBusSubscriber(modid="coordinatesdisplay", value={Dist.CLIENT})
    public static class ClientNeoforgeEvents {
        @SubscribeEvent
        public static void init(FMLClientSetupEvent e) {
            CoordinatesDisplay.init();
        }

        @SubscribeEvent
        public static void keyInput(InputEvent.Key e) {
            Player player = WorldUtils.getPlayer();
            if (player != null) {
                Bindings.checkBindings(Position.of(player));
            }
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void renderHud(RenderGuiEvent.Post event) {
            CoordinatesDisplay.renderHud(event.getGuiGraphics());
        }

        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent e) {
            e.register(Bindings.hudEnabled);
            e.register(Bindings.coordinatesGUIKeybind);
            e.register(Bindings.markGuiKeybind);
            e.register(Bindings.copyLocation);
            e.register(Bindings.sendLocation);
            e.register(Bindings.copyPosTp);
            e.register(Bindings.changeHudPosition);
            e.register(Bindings.cycleDisplayMode);
            e.register(Bindings.toggle3DCompass);
        }
    }
}

