/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.position;

import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class PlayerTargetBlock {
    BlockPos blockPos;
    String blockName;

    public PlayerTargetBlock(Entity camera) {
        HitResult blockHit = camera.pick(20.0, 0.0f, false);
        BlockPos targeted = null;
        String block = "?";
        if (blockHit.getType().equals((Object)HitResult.Type.BLOCK)) {
            targeted = ((BlockHitResult)blockHit).getBlockPos();
            BlockState blockState = WorldUtils.getWorld().getBlockState(targeted);
            block = ModUtil.getBlockName(blockState.getBlock());
        }
        this.blockPos = targeted;
        this.blockName = block;
    }

    public PlayerTargetBlock(BlockPos blockPos, String blockName) {
        this.blockPos = blockPos;
        this.blockName = blockName;
    }

    public String getBlockX() {
        return this.blockPos != null ? Integer.toString(this.blockPos.getX()) : "?";
    }

    public String getBlockY() {
        return this.blockPos != null ? Integer.toString(this.blockPos.getY()) : "?";
    }

    public String getBlockZ() {
        return this.blockPos != null ? Integer.toString(this.blockPos.getZ()) : "?";
    }

    public String getBlockName() {
        return this.blockName;
    }
}

