/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.forge;

import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.Bindings;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.gui.ConfigScreen;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod(value="coordinatesdisplay")
public class CoordinatesDisplayForge {
    public static boolean deltaError = false;

    public CoordinatesDisplayForge() {
        CoordinatesDisplay.init();
        ModList.get().getModContainerById("coordinatesdisplay").ifPresent(modContainer -> modContainer.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new ConfigScreen((Screen)screen))));
    }

    @Mod.EventBusSubscriber(modid="coordinatesdisplay", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent e) {
            e.register(Bindings.hudEnabled);
            e.register(Bindings.coordinatesGUIKeybind);
            e.register(Bindings.markGuiKeybind);
            e.register(Bindings.copyLocation);
            e.register(Bindings.sendLocation);
            e.register(Bindings.copyPosTp);
            e.register(Bindings.changeHudPosition);
            e.register(Bindings.cycleDisplayMode);
            e.register(Bindings.toggle3DCompass);
        }

        @SubscribeEvent
        public static void keyInput(InputEvent.Key e) {
            Player player = WorldUtils.getPlayer();
            if (player != null) {
                Bindings.checkBindings(Position.of(player));
            }
        }

        @SubscribeEvent
        public static void renderHud(CustomizeGuiOverlayEvent.Chat e) {
            CoordinatesDisplay.renderHud(e.getGuiGraphics());
        }
    }
}

