/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.gui;

import dev.boxadactle.boxlib.gui.config.widget.BCustomEntry;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.Hud;
import dev.boxadactle.coordinatesdisplay.ModConfig;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.position.Position;
import dev.boxadactle.coordinatesdisplay.registry.StartCorner;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;

public interface HudHelper {
    default public Position generatePositionData() {
        Vec3 pos = new Vec3(Math.random() * 1000.0, Math.random() * 5.0, Math.random() * 1000.0);
        BlockPos b = new BlockPos(ModUtil.doubleVecToIntVec(pos));
        ChunkPos chunkPos = new ChunkPos(b);
        float cameraYaw = (float)Math.random() * 180.0f;
        float cameraPitch = (float)Math.random() * 180.0f;
        return Position.of(ModUtil.fromMinecraftVector(pos), chunkPos, b, cameraYaw, cameraPitch, new BlockPos(b.getX() + 20, b.getY() + 20, b.getZ() + 20), "minecraft:grass_block");
    }

    default public ModConfig config() {
        return CoordinatesDisplay.getConfig();
    }

    default public BCustomEntry createHudRenderEntry(Position pos) {
        return new BCustomEntry((guiGraphics, x, y, width, height, mouseX, mouseY, tickDelta) -> CoordinatesDisplay.HUD.render((GuiGraphics)guiGraphics, Hud.RenderType.SCREEN, pos, x + width / 2 - CoordinatesDisplay.HUD.getWidth() / 2, y + 3, CoordinatesDisplay.getConfig().renderMode, StartCorner.TOP_LEFT));
    }
}

