/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.gui;

import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.math.geometry.Dimension;
import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.math.geometry.Vec2;
import dev.boxadactle.boxlib.math.mathutils.Clamps;
import dev.boxadactle.boxlib.prompt.Prompts;
import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.Hud;
import dev.boxadactle.coordinatesdisplay.ModConfig;
import dev.boxadactle.coordinatesdisplay.gui.HudHelper;
import dev.boxadactle.coordinatesdisplay.position.Position;
import dev.boxadactle.coordinatesdisplay.registry.StartCorner;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2fStack;

public class PositionScreen
extends BOptionScreen
implements HudHelper {
    int x;
    int y;
    float scale;
    int hudOffsetX;
    int hudOffsetY;
    boolean clickDelta = false;
    boolean scaleDelta = false;
    boolean moveDelta = false;
    Position pos = WorldUtils.getWorld() != null ? Position.of(WorldUtils.getPlayer()) : this.generatePositionData();
    boolean isDragging = false;

    public PositionScreen(Screen parent) {
        super(parent, (Component)Component.translatable((String)"screen.coordinatesdispaly.hudposition"));
        CoordinatesDisplay.shouldHudRender = false;
    }

    protected void init() {
        super.init();
        if (!this.config().renderMode.getMetadata().allowMove()) {
            CoordinatesDisplay.LOGGER.error((Object)("Cannot open the position screen when the render mode is set to " + String.valueOf((Object)this.config().renderMode)), new Object[0]);
            Prompts.alert((Screen)this.lastScreen, (Component)Component.translatable((String)"message.coordinatesdisplay.movehud.error", (Object[])new Object[]{this.config().renderMode.getComponent()}));
            CoordinatesDisplay.shouldHudRender = true;
        }
        Rect hud = CoordinatesDisplay.HUD.preRender(Hud.RenderType.SCREEN, this.pos, this.config().hudX, this.config().hudY, this.config().renderMode, this.config().startCorner).calculateRect();
        this.x = (Integer)hud.getX();
        this.y = (Integer)hud.getY();
        this.scale = ((ModConfig)CoordinatesDisplay.CONFIG.get()).hudScale;
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        if (this.moveHud(i, j)) {
            Rect rect = Clamps.clampRect((int)this.x, (int)this.y, (int)CoordinatesDisplay.HUD.getWidth(), (int)CoordinatesDisplay.HUD.getHeight(), (int)0, (int)0, (int)Math.round((float)this.width / this.scale), (int)Math.round((float)this.height / this.scale));
            this.x = (Integer)rect.getX();
            this.y = (Integer)rect.getY();
        }
        CoordinatesDisplay.HUD.render(guiGraphics, Hud.RenderType.SCREEN, this.pos, this.x, this.y, this.config().renderMode, StartCorner.TOP_LEFT, this.scale);
        if (CoordinatesDisplay.HUD.isHovered(i, j)) {
            Matrix3x2fStack stack = guiGraphics.pose();
            stack.pushMatrix();
            stack.scale(this.scale, this.scale);
            CoordinatesDisplay.HUD.renderMoveOverlay(guiGraphics, this.x, this.y);
            stack.popMatrix();
        }
    }

    public boolean moveHud(int mouseX, int mouseY) {
        if (this.isDragging) {
            if (!this.clickDelta) {
                this.clickDelta = true;
                if (CoordinatesDisplay.HUD.isScaleButtonHovered(mouseX, mouseY)) {
                    this.scaleDelta = true;
                    this.hudOffsetX = Math.round((float)this.x * this.scale);
                    this.hudOffsetY = Math.round((float)this.y * this.scale);
                } else {
                    this.moveDelta = true;
                    Dimension<Integer> offset = this.getDistance((Vec2<Integer>)new Vec2((Number)Math.round((float)mouseX / this.scale), (Number)Math.round((float)mouseY / this.scale)), (Vec2<Integer>)new Vec2((Number)this.x, (Number)this.y));
                    this.hudOffsetX = (Integer)offset.getWidth();
                    this.hudOffsetY = (Integer)offset.getHeight();
                }
            }
            if (this.scaleDelta) {
                this.scale = CoordinatesDisplay.HUD.calculateScale(this.hudOffsetX, this.hudOffsetY, mouseX, mouseY);
                this.x = Math.round((float)this.hudOffsetX / this.scale);
                this.y = Math.round((float)this.hudOffsetY / this.scale);
            } else {
                this.x = Math.round((float)mouseX / this.scale) - this.hudOffsetX;
                this.y = Math.round((float)mouseY / this.scale) - this.hudOffsetY;
            }
            return true;
        }
        if (this.clickDelta) {
            this.clickDelta = false;
            this.scaleDelta = false;
            this.moveDelta = false;
        }
        return false;
    }

    protected boolean shouldRenderScrollingWidget() {
        return false;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        this.isDragging = true;
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        this.isDragging = false;
        return super.mouseReleased(event);
    }

    public void onClose() {
        super.onClose();
        Vec2<Integer> translated = this.config().startCorner.getModifier().getRelativePos((Rect<Integer>)new Rect((Number)this.x, (Number)this.y, (Number)CoordinatesDisplay.HUD.getWidth(), (Number)CoordinatesDisplay.HUD.getHeight()), (Dimension<Integer>)new Dimension((Number)Math.round((float)this.width / this.scale), (Number)Math.round((float)this.height / this.scale)));
        this.config().hudX = (Integer)translated.getX();
        this.config().hudY = (Integer)translated.getY();
        this.config().hudScale = this.scale;
        if (WorldUtils.getWorld() != null) {
            CoordinatesDisplay.CONFIG.save();
        }
        CoordinatesDisplay.shouldHudRender = true;
    }

    protected void initFooter(LinearLayout layout) {
        layout.addChild((LayoutElement)this.createSaveButton(b -> this.onClose()));
    }

    protected void addOptions() {
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    private Dimension<Integer> getDistance(Vec2<Integer> vec1, Vec2<Integer> vec2) {
        int distanceX = (Integer)vec1.getX() - (Integer)vec2.getX();
        int distanceY = (Integer)vec1.getY() - (Integer)vec2.getY();
        return new Dimension((Number)distanceX, (Number)distanceY);
    }
}

