/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.mixin;

import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.RenderUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.ModConfig;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DeathScreen.class})
public class DeathScreenMixin
extends Screen {
    protected DeathScreenMixin(Component title) {
        super(title);
    }

    @Inject(at={@At(value="RETURN")}, method={"init"})
    private void init(CallbackInfo ci) {
        if (((ModConfig)CoordinatesDisplay.CONFIG.get()).displayPosOnDeathScreen) {
            this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"button.coordinatesdisplay.copy"), button -> {
                button.setMessage((Component)Component.translatable((String)"button.coordinatesdisplay.copied"));
                button.active = false;
                int x = (int)Math.round(ClientUtils.getClient().player.getX());
                int y = (int)Math.round(ClientUtils.getClient().player.getY());
                int z = (int)Math.round(ClientUtils.getClient().player.getZ());
                ClientUtils.getClient().keyboardHandler.setClipboard(x + " " + y + " " + z);
                CoordinatesDisplay.LOGGER.info((Object)"Copied death position to clipboard", new Object[0]);
            }).bounds(this.width / 2 - 100, this.height / 4 + 120, 200, 20).build());
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"render"})
    private void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (((ModConfig)CoordinatesDisplay.CONFIG.get()).displayPosOnDeathScreen) {
            DecimalFormat d = new DecimalFormat("0.00");
            String x = d.format(ClientUtils.getClient().player.getX());
            String y = d.format(ClientUtils.getClient().player.getY());
            String z = d.format(ClientUtils.getClient().player.getZ());
            Component pos = GuiUtils.colorize((Component)Component.translatable((String)"message.coordinatesdisplay.location", (Object[])new Object[]{x, y, z}), (int)((ModConfig)CoordinatesDisplay.CONFIG.get()).deathPosColor);
            RenderUtils.drawTextCentered((GuiGraphics)guiGraphics, (Component)Component.translatable((String)"message.coordinatesdisplay.deathpos", (Object[])new Object[]{pos}), (int)(this.width / 2), (int)115, (int)GuiUtils.WHITE);
        }
    }
}

