/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.position;

import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class PlayerWorldData {
    ResourceLocation dimension;
    Holder<Biome> biome;
    long day;
    long time;

    public PlayerWorldData(BlockPos player) {
        if (WorldUtils.getWorld() != null) {
            this.dimension = WorldUtils.getPlayer().level().dimension().location();
            this.biome = WorldUtils.getWorld().getBiome(player);
            this.day = WorldUtils.getWorld().getDayTime() / 24000L;
            this.time = WorldUtils.getWorld().getGameTime() % 24000L;
        } else {
            CoordinatesDisplay.LOGGER.warn((Object)"Client world is null! Resorting to default values.", new Object[0]);
            this.dimension = ResourceLocation.withDefaultNamespace((String)"overworld");
            this.day = Math.round(Math.random() * 1000.0);
            this.time = Math.round(Math.random() * 24000.0);
        }
    }

    public long getDay() {
        return this.day;
    }

    public long getTime() {
        return this.time;
    }

    private String formatName(String orig) {
        StringBuilder name = new StringBuilder();
        for (String word : orig.split("_")) {
            name.append(word.substring(0, 1).toUpperCase()).append(word.substring(1)).append(" ");
        }
        return name.toString().trim();
    }

    public String getDimension(boolean formatted) {
        return formatted ? this.formatName(this.dimension.getPath()) : this.dimension.toString();
    }

    public Biome getBiome() {
        if (this.biome != null) {
            return (Biome)this.biome.value();
        }
        return null;
    }

    public ResourceLocation getBiomeKey() {
        ResourceLocation def = ResourceLocation.withDefaultNamespace((String)"plains");
        if (this.biome == null) {
            return def;
        }
        return (ResourceLocation)this.biome.unwrap().map(ResourceKey::location, biome -> def);
    }
}

