/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.CenteredParagraphComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.math.geometry.Dimension;
import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.Hud;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudPositionModifier;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.mixin.OverlayMessageTimeAccessor;
import dev.boxadactle.coordinatesdisplay.position.Position;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import oshi.util.tuples.Triplet;

@HudDisplayMode(value="hotbar", ignoreTranslations=true, positionModifier=HotbarPosition.class, allowMove=false, hasBackground=false, hasChunkData=false, hasDirectionInt=false, hasMCVersion=false, hasDimension=false)
public class HotbarRenderer
implements HudRenderer {
    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        if (((OverlayMessageTimeAccessor)ClientUtils.getClient().gui).getOverlayMessageTime() > 0) {
            return new ColumnLayout(0, 0, 0);
        }
        ArrayList<Component> components = new ArrayList<Component>();
        Triplet<String, String, String> player = this.roundPosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), CoordinatesDisplay.getConfig().decimalPlaces);
        if (this.config().renderXYZ) {
            components.add(this.definition(HudRenderer.GlobalTexts.XYZ, this.value((String)player.getA()), this.value((String)player.getB()), this.value((String)player.getC())));
        }
        if (this.config().renderDirection) {
            components.add(this.definition(HudRenderer.GlobalTexts.FACING, this.value(this.resolveDirection(ModUtil.getDirectionFromYaw(pos.headRot.wrapYaw())))));
        }
        if (this.config().renderBiome) {
            ResourceLocation bKey = pos.world.getBiomeKey();
            Biome b = pos.world.getBiome();
            components.add(ModUtil.getBiomeComponent(bKey, b, this.config().biomeColors, this.config().dataColor));
        }
        if (this.config().renderDay) {
            components.add(this.definition(HudRenderer.GlobalTexts.DAY, this.value(Long.toString(pos.world.getDay()))));
        }
        MutableComponent all = Component.empty();
        Iterator it = components.iterator();
        while (it.hasNext()) {
            all.append((Component)it.next());
            if (!it.hasNext()) continue;
            all.append((Component)Component.literal((String)" / "));
        }
        ColumnLayout hud = new ColumnLayout(x, y, 0);
        hud.addComponent((LayoutComponent)new CenteredParagraphComponent(0, new Component[]{this.definition((Component)all)}));
        return hud;
    }

    public static class HotbarPosition
    implements HudPositionModifier.BasicPositionModifier {
        @Override
        public Rect<Integer> getPosition(Rect<Integer> rect, Dimension<Integer> ignored, Hud.RenderType type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case Hud.RenderType.SCREEN -> rect;
                case Hud.RenderType.HUD -> {
                    int j = ClientUtils.getClient().getWindow().getGuiScaledWidth() / 2;
                    int k = ClientUtils.getClient().getWindow().getGuiScaledHeight() - 68 - 4;
                    Rect r = rect.clone();
                    r.setX((Number)(j - (Integer)rect.getWidth() / 2));
                    r.setY((Number)k);
                    yield r;
                }
            };
        }
    }
}

