/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.gui;

import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.MouseUtils;
import dev.boxadactle.boxlib.util.RenderUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.ModConfig;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class CoordinatesScreen
extends Screen {
    Position pos;
    int buttonw = 300;
    int buttonh = 20;
    int p = 5;

    public CoordinatesScreen(Position pos) {
        super((Component)Component.literal((String)"Coordinates Screen"));
        this.pos = pos;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        Vec3<Double> player = this.pos.position.getPlayerPos();
        int x = (int)Math.round((Double)player.getX());
        int z = (int)Math.round((Double)player.getZ());
        int y = (int)Math.round((Double)player.getY());
        RenderUtils.drawTextCentered((GuiGraphics)guiGraphics, (Component)Component.translatable((String)"message.coordinatesdisplay.at"), (int)(this.width / 2), (int)(this.height / 4 - 20), (int)GuiUtils.WHITE);
        RenderUtils.drawTextCentered((GuiGraphics)guiGraphics, (Component)Component.translatable((String)"message.coordinatesdisplay.location", (Object[])new Object[]{x, y, z}), (int)(this.width / 2), (int)(this.height / 4), (int)GuiUtils.WHITE);
    }

    public void init() {
        super.init();
        int bstart = this.height / 2 - 20;
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"button.coordinatesdisplay.copy"), button -> {
            ClientUtils.getClient().keyboardHandler.setClipboard(ModUtil.parseText(((ModConfig)CoordinatesDisplay.CONFIG.get()).copyPosMessage, this.pos));
            CoordinatesDisplay.LOGGER.player.info("Copied coordinates to clipboard", new Object[0]);
            this.onClose();
        }).bounds(this.width / 2 - this.buttonw / 2, bstart, this.buttonw, this.buttonh).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"button.coordinatesdisplay.send"), button -> {
            CoordinatesDisplay.LOGGER.player.publicChat(ModUtil.parseText(((ModConfig)CoordinatesDisplay.CONFIG.get()).posChatMessage, this.pos));
            this.onClose();
        }).bounds(this.width / 2 - this.buttonw / 2, bstart + (this.buttonh + this.p), this.buttonw, this.buttonh).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"button.coordinatesdisplay.copytp"), button -> {
            ClientUtils.getClient().keyboardHandler.setClipboard(CoordinatesDisplay.getConfig().teleportMode.toCommand(Position.of(WorldUtils.getPlayer())));
            CoordinatesDisplay.LOGGER.player.info("Copied as TP command", new Object[0]);
            this.onClose();
        }).bounds(this.width / 2 - this.buttonw / 2, bstart + (this.buttonh + this.p) * 2, this.buttonw, this.buttonh).build());
    }

    public void onClose() {
        ClientUtils.setScreen(null);
        MouseUtils.getMouse().grabMouse();
    }
}

