/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.gui;

import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.BSpacingEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BEnumButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BScreenButton;
import dev.boxadactle.boxlib.gui.config.widget.label.BCenteredLabel;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.gui.HudHelper;
import dev.boxadactle.coordinatesdisplay.gui.PositionScreen;
import dev.boxadactle.coordinatesdisplay.position.Position;
import dev.boxadactle.coordinatesdisplay.registry.DisplayMode;
import dev.boxadactle.coordinatesdisplay.registry.StartCorner;
import dev.boxadactle.coordinatesdisplay.registry.VisibilityFilter;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class VisualScreen
extends BOptionScreen
implements HudHelper {
    Position pos = this.generatePositionData();
    AbstractWidget startCornerButton;
    AbstractWidget changeHudPosButton;

    public VisualScreen(Screen parent) {
        super(parent, (Component)Component.translatable((String)"screen.coordinatesdisplay.visual", (Object[])new Object[]{"CoordinatesDisplay v15.0.0"}));
    }

    protected void initFooter(LinearLayout layout) {
        this.setSaveButton((Button)layout.addChild((LayoutElement)this.createBackButton(this.lastScreen)));
        this.setWiki((Component)Component.translatable((String)"button.coordinatesdisplay.wiki"), CoordinatesDisplay.WIKI_VISUAL);
    }

    protected void addOptions() {
        Consumer<VisibilityFilter> var2 = newVal -> {
            this.config().visibilityFilter = newVal;
        };
        try {
            this.addConfigLine((BOptionEntry)new VisibilitySelector(this.config().visibilityFilter, var2));
        }
        catch (RuntimeException ignored) {
            CoordinatesDisplay.LOGGER.warn((Object)"Unknown visibility filter selected in config! Reverting to default.", new Object[0]);
            this.config().visibilityFilter = VisibilityFilter.ALWAYS;
            this.addConfigLine((BOptionEntry)new VisibilitySelector(this.config().visibilityFilter, var2));
        }
        this.startCornerButton = (AbstractWidget)this.addConfigLine((BOptionEntry)new BEnumButton("button.coordinatesdisplay.startcorner", (Enum)this.config().startCorner, StartCorner.class, newVal -> {
            this.config().startCorner = newVal;
        }, GuiUtils.AQUA));
        Consumer<DisplayMode> var4 = newVal -> {
            this.config().renderMode = newVal;
            this.verifyButtons();
        };
        try {
            this.addConfigLine((BOptionEntry)new DisplayModeSelector(this.config().renderMode, var4));
        }
        catch (RuntimeException e) {
            CoordinatesDisplay.LOGGER.warn((Object)"Unknown hud renderer selected in config! Reverting to default.", new Object[0]);
            this.config().renderMode = DisplayMode.DEFAULT;
            this.addConfigLine((BOptionEntry)new DisplayModeSelector(this.config().renderMode, var4));
        }
        this.addConfigLine((BOptionEntry)new BSpacingEntry());
        this.addConfigLine((BOptionEntry)new DecimalPlacesSlider("button.coordinatesdisplay.decimalPlaces", 0, 5, this.config().decimalPlaces, newVal -> {
            this.config().decimalPlaces = newVal;
        }));
        this.addConfigLine((BOptionEntry)new BBooleanButton("button.coordinatesdisplay.textshadow", Boolean.valueOf(this.config().hudTextShadow), newVal -> {
            this.config().hudTextShadow = newVal;
        }));
        this.addConfigLine((BOptionEntry)new BBooleanButton("button.coordinatesdisplay.biomecolors", Boolean.valueOf(this.config().biomeColors), newVal -> {
            this.config().biomeColors = newVal;
        }), (BOptionEntry)new BBooleanButton("button.coordinatesdisplay.dimensioncolors", Boolean.valueOf(this.config().dimensionColors), newVal -> {
            this.config().dimensionColors = newVal;
        }));
        this.changeHudPosButton = (AbstractWidget)this.addConfigLine((BOptionEntry)new BScreenButton((Component)Component.translatable((String)"button.coordinatesdisplay.editHudPos"), (Screen)this, PositionScreen::new));
        this.addConfigLine((BOptionEntry)new BIntegerSlider("button.coordinatesdisplay.padding", 0, 10, this.config().padding, newVal -> {
            this.config().padding = newVal;
        }), (BOptionEntry)new BIntegerSlider("button.coordinatesdisplay.textpadding", 0, 20, this.config().textPadding, newVal -> {
            this.config().textPadding = newVal;
        }));
        this.addConfigLine((BOptionEntry)new BSpacingEntry());
        this.addConfigLine((BOptionEntry)new BCenteredLabel((Component)Component.translatable((String)"label.coordinatesdisplay.preview")));
        this.addConfigLine((BOptionEntry)this.createHudRenderEntry(this.pos));
        for (int i = 0; i < 4; ++i) {
            this.addConfigLine((BOptionEntry)new BSpacingEntry());
        }
        this.verifyButtons();
    }

    private void verifyButtons() {
        HudDisplayMode metadata = this.config().renderMode.getMetadata();
        if (!metadata.ignoreTranslations()) {
            this.startCornerButton.active = true;
            this.startCornerButton.setTooltip(null);
        } else {
            this.startCornerButton.active = false;
            this.startCornerButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"message.coordintatesdisplay.disabled")));
        }
        if (this.config().renderMode.getMetadata().allowMove()) {
            this.changeHudPosButton.active = true;
            this.changeHudPosButton.setTooltip(null);
        } else {
            this.changeHudPosButton.active = false;
            this.changeHudPosButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"message.coordintatesdisplay.disabled")));
        }
    }

    public static class VisibilitySelector
    extends BEnumButton<VisibilityFilter> {
        public VisibilitySelector(VisibilityFilter value, Consumer<VisibilityFilter> function) {
            super("button.coordinatesdisplay.visibility", (Enum)value, VisibilityFilter.class, function, GuiUtils.AQUA);
        }

        public Component from(VisibilityFilter input) {
            return GuiUtils.colorize((Component)input.getComponent(), (int)this.valColor);
        }
    }

    public static class DisplayModeSelector
    extends BEnumButton<DisplayMode> {
        public DisplayModeSelector(DisplayMode value, Consumer<DisplayMode> function) {
            super("button.coordinatesdisplay.displayMode", (Enum)value, DisplayMode.class, function, GuiUtils.AQUA);
        }

        public Component from(DisplayMode input) {
            return GuiUtils.colorize((Component)input.getComponent(), (int)this.valColor);
        }
    }

    public static class DecimalPlacesSlider
    extends BIntegerSlider {
        public DecimalPlacesSlider(String key, int min, int max, int value, Consumer<Integer> function) {
            super(key, min, max, value, function);
            this.updateMessage();
        }

        protected String roundNumber(Integer input) {
            return input == 0 ? "0 (" + GuiUtils.getTranslatable((String)"button.coordinatesdisplay.decimalPlaces.block_pos") + ")" : super.roundNumber(input);
        }
    }
}

