/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.position;

import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.coordinatesdisplay.position.PlayerHeadRot;
import dev.boxadactle.coordinatesdisplay.position.PlayerPos;
import dev.boxadactle.coordinatesdisplay.position.PlayerTargetBlock;
import dev.boxadactle.coordinatesdisplay.position.PlayerWorldData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;

public class Position {
    public PlayerPos position;
    public PlayerHeadRot headRot;
    public PlayerWorldData world;
    public PlayerTargetBlock block;

    public static Position of(Player player) {
        Vec3 a = new Vec3((Number)player.getX(), (Number)player.getY(), (Number)player.getZ());
        BlockPos b = new BlockPos(player.getBlockX(), player.getBlockY(), player.getBlockZ());
        return new Position((Vec3<Double>)a, new ChunkPos(b), b, player.getYHeadRot(), player.getXRot(), new PlayerTargetBlock((Entity)player));
    }

    public static Position of(Vec3<Double> player, ChunkPos chunkPos, BlockPos playerPos, float yaw, float pitch, BlockPos targetPos, String targetName) {
        return new Position(player, chunkPos, playerPos, yaw, pitch, new PlayerTargetBlock(targetPos, targetName));
    }

    protected Position(Vec3<Double> player, ChunkPos chunkPos, BlockPos playerPos, float yaw, float pitch, PlayerTargetBlock playerTargetBlock) {
        this.position = new PlayerPos((Double)player.getX(), (Double)player.getY(), (Double)player.getZ(), chunkPos, playerPos);
        this.headRot = new PlayerHeadRot(yaw, pitch);
        this.world = new PlayerWorldData(playerPos);
        this.block = playerTargetBlock;
    }
}

