/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.math.geometry.Vec2;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.position.Position;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;

@HudDisplayMode(value="chunk", hasXYZ=false, hasBiome=false, hasDimension=false, hasChunkData=false, hasDirection=false, hasDirectionInt=false, hasMCVersion=false, hasDay=false)
public class ChunkRenderer
implements HudRenderer {
    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        RowLayout hud = new RowLayout(0, 0, this.config().textPadding);
        ColumnLayout left = new ColumnLayout(0, 0, this.config().textPadding);
        Vec2<Integer> chunkPos = pos.position.getChunkPos();
        Component position = this.definition(this.translation("position", new Object[0]));
        Component chunkX = this.definition(HudRenderer.GlobalTexts.CHUNK_X, this.value(Integer.toString((Integer)chunkPos.getX())));
        Component chunkY = this.definition(HudRenderer.GlobalTexts.CHUNK_Y, this.value(Integer.toString(pos.position.getChunkY())));
        Component chunkZ = this.definition(HudRenderer.GlobalTexts.CHUNK_Z, this.value(Integer.toString((Integer)chunkPos.getY())));
        left.addComponent((LayoutComponent)new ParagraphComponent(2, new Component[]{position, chunkX, chunkY, chunkZ}));
        ChunkPos chunkPos1 = new ChunkPos(ModUtil.toBlockPos(pos.position.getBlockPos()));
        Component region = this.definition(this.translation("region", new Object[0]));
        Component rFile = this.value(String.format("r.%d.%d.mca", chunkPos1.getRegionX(), chunkPos1.getRegionZ()));
        Component localRegion = this.value(String.format("%d %d", chunkPos1.getRegionLocalX(), chunkPos1.getRegionLocalZ()));
        left.addComponent((LayoutComponent)new ParagraphComponent(2, new Component[]{region, rFile, localRegion}));
        hud.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)left));
        ColumnLayout right = new ColumnLayout(0, 0, this.config().textPadding);
        Component chunks = this.definition(this.translation("chunks", new Object[0]));
        String var1 = ClientUtils.getClient().level != null ? ClientUtils.getClient().level.gatherChunkSourceStats() : "Chunks[C] W: 0/0";
        Pattern chunksPattern = Pattern.compile("Client Chunk Cache: (\\d+), (\\d+)");
        Matcher chunksMatcher = chunksPattern.matcher(var1);
        boolean var3 = chunksMatcher.find();
        Component cached = this.definition(this.translation("chunks.cached", this.value(var3 ? chunksMatcher.group(1) : "0")));
        Component memory = this.definition(this.translation("chunks.memory", this.value(var3 ? chunksMatcher.group(2) : "0")));
        right.addComponent((LayoutComponent)new ParagraphComponent(2, new Component[]{chunks, cached, memory}));
        Component c = this.definition(this.translation("c", new Object[0]));
        String var2 = ClientUtils.getClient().level != null ? ClientUtils.getClient().levelRenderer.getSectionStatistics() : "C: 0/0";
        Pattern cPattern = Pattern.compile("C: (\\d+)/(\\d+) \\(s\\)");
        Matcher cMatcher = cPattern.matcher(var2);
        boolean var4 = cMatcher.find();
        Component rendered = this.definition(this.translation("c.rendered", this.value(var4 ? cMatcher.group(1) : "0")));
        Component loaded = this.definition(this.translation("c.loaded", this.value(var4 ? cMatcher.group(2) : "0")));
        right.addComponent((LayoutComponent)new ParagraphComponent(2, new Component[]{c, rendered, loaded}));
        hud.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)right));
        return new PaddingLayout(x, y, this.config().padding, (RenderingLayout)hud);
    }
}

