/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay;

import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.math.geometry.Dimension;
import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.math.geometry.Vec2;
import dev.boxadactle.boxlib.math.mathutils.Clamps;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.RenderUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.ModConfig;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.position.Position;
import dev.boxadactle.coordinatesdisplay.registry.DisplayMode;
import dev.boxadactle.coordinatesdisplay.registry.StartCorner;
import dev.boxadactle.coordinatesdisplay.registry.VisibilityFilter;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;

public class Hud {
    Rect<Integer> size = new Rect((Number)0, (Number)0, (Number)0, (Number)0);
    int scaleSize;
    float scale;
    Rect<Integer> scaleButton;

    public Hud() {
        this.scale = ((ModConfig)CoordinatesDisplay.CONFIG.get()).hudScale;
        this.scaleButton = new Rect((Number)0, (Number)0, (Number)0, (Number)0);
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return ModUtil.isMouseHovering(Math.round((float)mouseX / this.scale), Math.round((float)mouseY / this.scale), (Integer)this.size.getX(), (Integer)this.size.getY(), (Integer)this.size.getWidth(), (Integer)this.size.getHeight());
    }

    public boolean isScaleButtonHovered(int mouseX, int mouseY) {
        return this.scaleButton.containsPoint(new Vec2((Number)Math.round((float)mouseX / this.scale), (Number)Math.round((float)mouseY / this.scale)));
    }

    public boolean shouldRender(VisibilityFilter filter) {
        boolean bl = true;
        bl &= !ClientUtils.getOptions().field_1842;
        bl &= !ClientUtils.getClient().method_53526().method_53536();
        bl &= CoordinatesDisplay.shouldHudRender;
        return (bl &= filter.getFilter().isVisible()) && CoordinatesDisplay.getConfig().enabled;
    }

    public RenderingLayout preRender(RenderType thread, Position pos, int x, int y, DisplayMode renderMode, StartCorner startCorner) {
        try {
            RenderingLayout layout = renderMode.getRenderer().renderOverlay(x, y, pos);
            Rect startSize = layout.calculateRect();
            Dimension window = new Dimension((Number)Math.round((float)ClientUtils.getClient().method_22683().method_4486() / this.scale), (Number)Math.round((float)ClientUtils.getClient().method_22683().method_4502() / this.scale));
            Rect<Integer> newPos = renderMode.getMetadata().ignoreTranslations() ? renderMode.getMetadata().positionModifier().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getPosition((Rect<Integer>)startSize, (Dimension<Integer>)window, thread) : startCorner.getModifier().translateRect((Rect<Integer>)startSize, (Dimension<Integer>)window);
            layout.setPosition(((Integer)newPos.getX()).intValue(), ((Integer)newPos.getY()).intValue());
            return layout;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void render(class_332 guiGraphics, RenderingLayout layout, DisplayMode renderMode) {
        try {
            Rect<Integer> size = HudRenderer.renderHud(guiGraphics, layout, renderMode.getMetadata().hasBackground());
            this.size.setX((Number)((Integer)size.getX()));
            this.size.setY((Number)((Integer)size.getY()));
            this.size.setWidth((Number)((Integer)size.getWidth()));
            this.size.setHeight((Number)((Integer)size.getHeight()));
        }
        catch (NullPointerException e) {
            CoordinatesDisplay.LOGGER.error((Object)"An unexpected error occurred!", new Object[0]);
            CoordinatesDisplay.LOGGER.printStackTrace((Exception)e);
        }
    }

    public void render(class_332 guiGraphics, RenderType thread, Position pos, int x, int y, DisplayMode renderMode, StartCorner startCorner) {
        RenderingLayout layout = this.preRender(thread, pos, x, y, renderMode, startCorner);
        this.render(guiGraphics, layout, renderMode);
    }

    public void render(class_332 guiGraphics, RenderType thread, Position pos, int x, int y, DisplayMode renderMode, StartCorner startCorner, float scale) {
        try {
            if (!renderMode.getMetadata().ignoreTranslations()) {
                Matrix3x2fStack stack = guiGraphics.method_51448();
                stack.pushMatrix();
                stack.scale(scale, scale);
                this.scale = scale;
                this.render(guiGraphics, thread, pos, x, y, renderMode, startCorner);
                stack.popMatrix();
            } else {
                this.render(guiGraphics, thread, pos, x, y, renderMode, startCorner);
            }
        }
        catch (NullPointerException e) {
            CoordinatesDisplay.LOGGER.printStackTrace((Exception)e);
        }
    }

    public Rect<Integer> getRect() {
        return this.size;
    }

    public int getWidth() {
        return (Integer)this.size.getWidth();
    }

    public int getHeight() {
        return (Integer)this.size.getHeight();
    }

    public void renderMoveOverlay(class_332 guiGraphics, int x, int y) {
        int color = 1355270087;
        this.scaleSize = 5;
        int scaleColor = -1713766406;
        RenderUtils.drawSquare((class_332)guiGraphics, (int)x, (int)y, (int)((Integer)this.size.getWidth()), (int)((Integer)this.size.getHeight()), (int)color);
        this.scaleButton = new Rect((Number)(this.size.getMaxX() - this.scaleSize), (Number)(this.size.getMaxY() - this.scaleSize), (Number)this.scaleSize, (Number)this.scaleSize);
        int scaleX = (Integer)this.scaleButton.getX();
        int scaleY = (Integer)this.scaleButton.getY();
        RenderUtils.drawSquare((class_332)guiGraphics, (int)scaleX, (int)scaleY, (int)this.scaleSize, (int)this.scaleSize, (int)scaleColor);
    }

    public float calculateScale(int x, int y, int mouseX, int mouseY) {
        float rectSize = ModUtil.calculatePointDistance(x, y, x + (Integer)this.size.getWidth(), y + (Integer)this.size.getY());
        float mouseSize = ModUtil.calculatePointDistance(x, y, mouseX, mouseY);
        float scaleFactor = mouseSize / rectSize;
        scaleFactor = (float)Math.round(scaleFactor * 10.0f) / 10.0f;
        scaleFactor = Clamps.clamp((float)scaleFactor, (float)0.5f, (float)2.0f);
        return scaleFactor;
    }

    public int getX() {
        return (Integer)this.size.getX();
    }

    public int getY() {
        return (Integer)this.size.getY();
    }

    public static enum RenderType {
        SCREEN,
        HUD;

    }
}

