/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import dev.boxadactle.boxlib.scheduling.Scheduling;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.ModConfig;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.gui.CoordinatesScreen;
import dev.boxadactle.coordinatesdisplay.gui.PositionScreen;
import dev.boxadactle.coordinatesdisplay.marking.MarkGui;
import dev.boxadactle.coordinatesdisplay.position.Position;
import dev.boxadactle.coordinatesdisplay.registry.DisplayMode;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class Bindings {
    public static final KeyMapping.Category CATEGORY = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"coordinatesdisplay", (String)"keybinds"));
    public static final KeyMapping hudEnabled = new KeyMapping("key.coordinatesdisplay.hudenabled", 72, CATEGORY);
    public static final KeyMapping coordinatesGUIKeybind = new KeyMapping("key.coordinatesdisplay.coordinatesgui", 67, CATEGORY);
    public static final KeyMapping markGuiKeybind = new KeyMapping("key.coordinatesdisplay.markpos", 66, CATEGORY);
    public static final KeyMapping copyLocation = new KeyMapping("key.coordinatesdisplay.copypos", -1, CATEGORY);
    public static final KeyMapping sendLocation = new KeyMapping("key.coordinatesdisplay.sendpos", -1, CATEGORY);
    public static final KeyMapping copyPosTp = new KeyMapping("key.coordinatesdisplay.copypostp", -1, CATEGORY);
    public static final KeyMapping changeHudPosition = new KeyMapping("key.coordinatesdisplay.changeHudPos", 298, CATEGORY);
    public static final KeyMapping cycleDisplayMode = new KeyMapping("key.coordinatesdisplay.cycleDisplayMode", 77, CATEGORY);
    public static final KeyMapping toggle3DCompass = new KeyMapping("key.coordinatesdisplay.toggle3DCompass", 297, CATEGORY);

    public static void toggleHud() {
        CoordinatesDisplay.LOGGER.info((Object)"Toggling HUD visibility", new Object[0]);
        ((ModConfig)CoordinatesDisplay.CONFIG.get()).enabled = !((ModConfig)CoordinatesDisplay.CONFIG.get()).enabled;
        CoordinatesDisplay.CONFIG.save();
    }

    public static void coordinatesGui() {
        Scheduling.nextTick(() -> ClientUtils.setScreen((Screen)new CoordinatesScreen(Position.of(WorldUtils.getPlayer()))));
    }

    public static void markGui() {
        Scheduling.nextTick(() -> ClientUtils.setScreen((Screen)new MarkGui()));
    }

    public static void copyLocation(Position pos) {
        ClientUtils.getKeyboard().setClipboard(ModUtil.parseText(((ModConfig)CoordinatesDisplay.CONFIG.get()).copyPosMessage, pos));
        CoordinatesDisplay.LOGGER.player.info("Copied to clipboard!", new Object[0]);
        CoordinatesDisplay.LOGGER.info((Object)"Copied location to clipboard", new Object[0]);
    }

    public static void sendLocation(Position pos) {
        CoordinatesDisplay.LOGGER.player.publicChat(ModUtil.parseText(((ModConfig)CoordinatesDisplay.CONFIG.get()).posChatMessage, pos));
        CoordinatesDisplay.LOGGER.info((Object)"Sent position as chat message", new Object[0]);
    }

    public static void copyTeleportCommand(Position pos) {
        ClientUtils.getKeyboard().setClipboard(CoordinatesDisplay.getConfig().teleportMode.toCommand(pos));
        CoordinatesDisplay.LOGGER.player.info("Copied position as teleport command!", new Object[0]);
    }

    public static void openHudPositionGui() {
        Scheduling.nextTick(() -> ClientUtils.setScreen((Screen)new PositionScreen(null)));
    }

    public static void cycleDisplayMode() {
        CoordinatesDisplay.getConfig().renderMode = !InputConstants.isKeyDown((Window)ClientUtils.getClient().getWindow(), (int)340) ? DisplayMode.nextMode(CoordinatesDisplay.getConfig().renderMode) : DisplayMode.previousMode(CoordinatesDisplay.getConfig().renderMode);
        CoordinatesDisplay.CONFIG.save();
    }

    public static void toggle3DCompass() {
        CoordinatesDisplay.getConfig().render3dCompass = !CoordinatesDisplay.getConfig().render3dCompass;
        CoordinatesDisplay.CONFIG.save();
    }

    public static void checkBindings(Position pos) {
        if (hudEnabled.consumeClick()) {
            Bindings.toggleHud();
        }
        if (coordinatesGUIKeybind.consumeClick()) {
            Bindings.coordinatesGui();
        }
        if (markGuiKeybind.consumeClick()) {
            Bindings.markGui();
        }
        if (copyLocation.consumeClick()) {
            Bindings.copyLocation(pos);
        }
        if (sendLocation.consumeClick()) {
            Bindings.sendLocation(pos);
        }
        if (copyPosTp.consumeClick()) {
            Bindings.copyTeleportCommand(pos);
        }
        if (changeHudPosition.consumeClick()) {
            Bindings.openHudPositionGui();
        }
        if (cycleDisplayMode.consumeClick()) {
            Bindings.cycleDisplayMode();
        }
        if (toggle3DCompass.consumeClick()) {
            Bindings.toggle3DCompass();
        }
    }
}

