/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay;

import com.mojang.datafixers.util.Pair;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.ModConfig;
import dev.boxadactle.coordinatesdisplay.WorldColors;
import dev.boxadactle.coordinatesdisplay.marking.MarkPoint;
import dev.boxadactle.coordinatesdisplay.position.Position;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.SystemUtils;

public class ModUtil {
    public static String parseText(String text, Position pos) {
        Pair[] supported;
        Minecraft c = ClientUtils.getClient();
        String newTextComponent = text;
        DecimalFormat decimalFormat = new DecimalFormat(((ModConfig)CoordinatesDisplay.CONFIG.get()).includeDecimalsWhenCopying ? "0.00" : "0");
        dev.boxadactle.boxlib.math.geometry.Vec3<Double> player = pos.position.getPlayerPos();
        String x = decimalFormat.format(player.getX());
        String y = decimalFormat.format(player.getY());
        String z = decimalFormat.format(player.getZ());
        String direction = ModUtil.getDirectionFromYaw(Mth.wrapDegrees((float)c.player.getXRot()));
        for (Pair pair : supported = new Pair[]{new Pair((Object)"dimension", (Object)pos.world.getDimension(true)), new Pair((Object)"x", (Object)x), new Pair((Object)"y", (Object)y), new Pair((Object)"z", (Object)z), new Pair((Object)"direction", (Object)direction), new Pair((Object)"name", (Object)Objects.requireNonNull(c.player.getDisplayName()).getString())}) {
            newTextComponent = newTextComponent.replaceAll("\\{" + String.valueOf(pair.getFirst()) + "}", (String)pair.getSecond());
        }
        return newTextComponent;
    }

    public static String toExecuteCommand(Position pos) {
        int x = (int)Math.round((Double)pos.position.getPlayerPos().getX());
        int y = (int)Math.round((Double)pos.position.getPlayerPos().getY());
        int z = (int)Math.round((Double)pos.position.getPlayerPos().getZ());
        String dimension = pos.world.getDimension(false);
        return String.format("/execute in %s run tp @s %d %d %d", dimension, x, y, z);
    }

    public static String toTeleportCommand(Position pos) {
        int x = (int)Math.round((Double)pos.position.getPlayerPos().getX());
        int y = (int)Math.round((Double)pos.position.getPlayerPos().getY());
        int z = (int)Math.round((Double)pos.position.getPlayerPos().getZ());
        return String.format("/tp @s %d %d %d", x, y, z);
    }

    public static String toBaritoneCommand(Position pos) {
        int x = (int)Math.round((Double)pos.position.getPlayerPos().getX());
        int y = (int)Math.round((Double)pos.position.getPlayerPos().getY());
        int z = (int)Math.round((Double)pos.position.getPlayerPos().getZ());
        return String.format("#goto %s %s %s", x, y, z);
    }

    public static Component makeDeathPositionComponent(Position pos) {
        dev.boxadactle.boxlib.math.geometry.Vec3<Double> player = pos.position.getPlayerPos();
        String command = CoordinatesDisplay.getConfig().teleportMode.toCommand(pos);
        int x = (int)Math.round((Double)player.getX());
        int y = (int)Math.round((Double)player.getY());
        int z = (int)Math.round((Double)player.getZ());
        MutableComponent position = Component.translatable((String)"message.coordinatesdisplay.deathlocation", (Object[])new Object[]{x, y, z, pos.world.getDimension(false)}).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"message.coordinatesdisplay.teleport"))).withColor(TextColor.fromRgb((int)((ModConfig)CoordinatesDisplay.CONFIG.get()).deathPosColor)).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand(String.format(command, x, y, z))));
        return GuiUtils.colorize((Component)Component.translatable((String)"message.coordinatesdisplay.deathpos", (Object[])new Object[]{position}), (int)((ModConfig)CoordinatesDisplay.CONFIG.get()).definitionColor);
    }

    public static Component makeMarkComponent(dev.boxadactle.boxlib.math.geometry.Vec3<Integer> mark, String playername) {
        String command = MarkPoint.createCommand(mark);
        MutableComponent select = Component.translatable((String)"message.coordinatesdisplay.mark.select").withStyle(s -> s.withColor(ChatFormatting.GOLD).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"message.coordinatesdisplay.mark.select.message"))).withClickEvent((ClickEvent)new ClickEvent.RunCommand(command)));
        return GuiUtils.colorize((Component)Component.translatable((String)"message.coordinatesdisplay.mark.shared", (Object[])new Object[]{playername, select}), (int)GuiUtils.AQUA);
    }

    public static String getBlockName(Block block) {
        try {
            Class<?> modUtilImplClass = Class.forName("dev.boxadactle.coordinatesdisplay.ModUtilImpl");
            return (String)modUtilImplClass.getMethod("getBlockName", Block.class).invoke(null, block);
        }
        catch (ReflectiveOperationException e) {
            return "unknown_block";
        }
    }

    public static boolean openConfigFile() {
        boolean worked;
        CoordinatesDisplay.LOGGER.info((Object)"Trying to open file in native file explorer...", new Object[0]);
        File f = new File(ClientUtils.getClient().gameDirectory.getAbsolutePath() + "\\config");
        if (SystemUtils.OS_NAME.toLowerCase().contains("windows")) {
            try {
                Runtime.getRuntime().exec(new String[]{"explorer.exe", f.getAbsolutePath()});
                worked = true;
            }
            catch (IOException e) {
                CoordinatesDisplay.LOGGER.error((Object)"Got an error: ", new Object[0]);
                CoordinatesDisplay.LOGGER.printStackTrace((Exception)e);
                worked = false;
            }
        } else if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browseFileDirectory(f);
            CoordinatesDisplay.LOGGER.info((Object)"Opened directory", new Object[0]);
            worked = true;
        } else {
            CoordinatesDisplay.LOGGER.warn((Object)"Incompatible with desktop class", new Object[0]);
            worked = false;
        }
        return worked;
    }

    public static String getDirectionFromYaw(double degrees) {
        String direction;
        String[] directions = new String[]{"south", "southwest", "west", "northwest", "north", "northeast", "east", "southeast", "south"};
        if (degrees > 0.0) {
            direction = directions[(int)Math.round(degrees / 45.0)];
        } else {
            int index = (int)Math.round(degrees / 45.0) * -1;
            direction = directions[8 - index];
        }
        return direction;
    }

    public static Component getBiomeComponent(ResourceLocation key, Biome biome, boolean colored, int defaultColor) {
        if (biome == null && WorldUtils.getWorld() != null) {
            return GuiUtils.colorize((Component)Component.translatable((String)"hud.coordinatesdisplay.biome.unknown"), (int)defaultColor);
        }
        return GuiUtils.colorize((Component)Component.translatable((String)("biome." + key.getNamespace() + "." + key.getPath())), (int)(colored ? WorldColors.getBiomeColor(key, biome) : defaultColor));
    }

    public static boolean isMouseHovering(int mouseX, int mouseY, int boxX, int boxY, int boxWidth, int boxHeight) {
        return mouseX >= boxX && mouseX <= boxX + boxWidth && mouseY >= boxY && mouseY <= boxY + boxHeight;
    }

    public static String getNamespace(String id) {
        return id.split(":")[0];
    }

    public static float calculatePointDistance(int x, int y, int x1, int y1) {
        int deltaX = x1 - x;
        int deltaY = y1 - y;
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        return (float)distance;
    }

    public static float calculatePointDistance3d(dev.boxadactle.boxlib.math.geometry.Vec3<Double> point1, dev.boxadactle.boxlib.math.geometry.Vec3<Double> point2) {
        double deltaX = (Double)point2.getX() - (Double)point1.getX();
        double deltaY = (Double)point2.getY() - (Double)point1.getY();
        double deltaZ = (Double)point2.getZ() - (Double)point1.getZ();
        return (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static <T> boolean or(T val, T ... compare) {
        boolean toReturn = false;
        for (T t : compare) {
            if (!val.equals(t)) continue;
            toReturn = true;
            break;
        }
        return toReturn;
    }

    public static <T> boolean not(T val, T ... compare) {
        boolean toReturn = true;
        for (T t : compare) {
            if (!val.equals(t)) continue;
            toReturn = false;
            break;
        }
        return toReturn;
    }

    public static Vec3i doubleVecToIntVec(Vec3 vec) {
        return new Vec3i((int)Math.round(vec.x), (int)Math.round(vec.y), (int)Math.round(vec.z));
    }

    public static dev.boxadactle.boxlib.math.geometry.Vec3<Double> fromMinecraftVector(Vec3 vec3d) {
        return new dev.boxadactle.boxlib.math.geometry.Vec3((Number)vec3d.x, (Number)vec3d.y, (Number)vec3d.z);
    }

    public static BlockPos toBlockPos(dev.boxadactle.boxlib.math.geometry.Vec3<Integer> vec) {
        return new BlockPos(((Integer)vec.getX()).intValue(), ((Integer)vec.getY()).intValue(), ((Integer)vec.getZ()).intValue());
    }
}

