/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.gui;

import dev.boxadactle.boxlib.gui.config.BOptionButton;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.BSpacingEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BCustomButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BLinkButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BScreenButton;
import dev.boxadactle.boxlib.prompt.Prompts;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.ModConfig;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.gui.ColorScreen;
import dev.boxadactle.coordinatesdisplay.gui.DeathPosScreen;
import dev.boxadactle.coordinatesdisplay.gui.RenderScreen;
import dev.boxadactle.coordinatesdisplay.gui.TextScreen;
import dev.boxadactle.coordinatesdisplay.gui.VisualScreen;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigScreen
extends BOptionScreen {
    public ConfigScreen(Screen parent) {
        super(parent, (Component)Component.translatable((String)"screen.coordinatesdisplay.config", (Object[])new Object[]{"CoordinatesDisplay v15.0.0"}));
        try {
            ModConfig.checkValidity((ModConfig)CoordinatesDisplay.CONFIG.get());
            CoordinatesDisplay.CONFIG.cacheConfig();
        }
        catch (NullPointerException e) {
            Prompts.alert((Screen)this, (Component)Component.translatable((String)"message.coordinatesdisplay.configError"));
            CoordinatesDisplay.CONFIG.resetConfig();
            CoordinatesDisplay.CONFIG.save();
            CoordinatesDisplay.CONFIG.cacheConfig();
            CoordinatesDisplay.LOGGER.printStackTrace((Exception)e);
        }
    }

    protected void initFooter(LinearLayout layout) {
        layout.addChild((LayoutElement)this.createCancelButton(b -> {
            ClientUtils.setScreen((Screen)this.lastScreen);
            CoordinatesDisplay.CONFIG.restoreCache();
        }));
        this.setSaveButton((Button)layout.addChild((LayoutElement)this.createSaveButton(b -> {
            ClientUtils.setScreen((Screen)this.lastScreen);
            CoordinatesDisplay.CONFIG.save();
        })));
    }

    protected void addOptions() {
        this.addConfigLine((BOptionEntry)new BBooleanButton("button.coordinatesdisplay.enabled", Boolean.valueOf(CoordinatesDisplay.getConfig().enabled), val -> {
            CoordinatesDisplay.getConfig().enabled = val;
        }));
        this.addConfigLine((BOptionEntry)new BScreenButton((Component)Component.translatable((String)"button.coordinatesdisplay.visualconfig"), (Screen)this, VisualScreen::new));
        this.addConfigLine((BOptionEntry)new BScreenButton((Component)Component.translatable((String)"button.coordinatesdisplay.renderconfig"), (Screen)this, RenderScreen::new));
        this.addConfigLine((BOptionEntry)new BScreenButton((Component)Component.translatable((String)"button.coordinatesdisplay.colorconfig"), (Screen)this, ColorScreen::new));
        this.addConfigLine((BOptionEntry)new BScreenButton((Component)Component.translatable((String)"button.coordinatesdisplay.deathpos"), (Screen)this, DeathPosScreen::new));
        this.addConfigLine((BOptionEntry)new BScreenButton((Component)Component.translatable((String)"button.coordinatesdisplay.text"), (Screen)this, TextScreen::new));
        this.addConfigLine((BOptionEntry)new BBooleanButton("button.coordinatesdisplay.3dcompass", Boolean.valueOf(CoordinatesDisplay.getConfig().render3dCompass), val -> {
            CoordinatesDisplay.getConfig().render3dCompass = val;
        }));
        this.addConfigLine((BOptionEntry)new BSpacingEntry());
        this.addConfigLine((BOptionEntry)new BCustomButton(this, (Component)Component.translatable((String)"button.coordinatesdisplay.configfile")){

            protected void buttonClicked(BOptionButton<?> button) {
                button.active = false;
                if (ModUtil.openConfigFile()) {
                    button.setMessage((Component)Component.translatable((String)"button.coordinatesdisplay.configfilesuccess"));
                } else {
                    button.setMessage((Component)Component.translatable((String)"button.coordinatesdisplay.configfilefail"));
                }
            }
        });
        this.addConfigLine((BOptionEntry)new BCustomButton((Component)Component.translatable((String)"button.coordinatesdisplay.resetdefault")){

            protected void buttonClicked(BOptionButton<?> button) {
                Screen configScreen = ClientUtils.getCurrentScreen();
                ClientUtils.setScreen((Screen)new ConfirmScreen(doIt -> {
                    if (doIt) {
                        CoordinatesDisplay.CONFIG.resetConfig();
                        ClientUtils.setScreen((Screen)new ConfigScreen(ConfigScreen.this.parent));
                    } else {
                        ClientUtils.setScreen((Screen)configScreen);
                    }
                }, (Component)Component.translatable((String)"screen.coordinatesdisplay.confirmreset"), (Component)Component.translatable((String)"message.coordinatesdisplay.confirmreset")));
            }
        });
        this.addConfigLine((BOptionEntry)new BLinkButton((Component)Component.translatable((String)"button.coordinatesdisplay.wiki"), "https://boxadactle.dev/wiki/coordinates-display/"));
    }
}

