/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.registry;

import dev.boxadactle.boxlib.core.BoxLib;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.coordinatesdisplay.HudVisibility;
import dev.boxadactle.coordinatesdisplay.HudVisibilityFilter;
import dev.boxadactle.coordinatesdisplay.visibility.AlwaysVisibility;
import dev.boxadactle.coordinatesdisplay.visibility.HoldCompassVisibility;
import dev.boxadactle.coordinatesdisplay.visibility.HoldMapVisibility;
import dev.boxadactle.coordinatesdisplay.visibility.OwnCompassVisibility;
import dev.boxadactle.coordinatesdisplay.visibility.OwnMapVisibility;
import net.minecraft.network.chat.Component;

public enum VisibilityFilter {
    ALWAYS(AlwaysVisibility.class),
    HOLD_COMPASS(HoldCompassVisibility.class),
    OWN_COMPASS(OwnCompassVisibility.class),
    HOLD_MAP(HoldMapVisibility.class),
    OWN_MAP(OwnMapVisibility.class);

    HudVisibilityFilter filter;
    HudVisibility metadata;

    private VisibilityFilter(Class<? extends HudVisibilityFilter> filter) {
        this.filter = (HudVisibilityFilter)BoxLib.initializeClass(filter);
        HudVisibility m = filter.getAnnotation(HudVisibility.class);
        if (m == null) {
            throw new IllegalStateException("Attempting to register Hud visibility filter without Hud.VisibilityFilter annotation!");
        }
        this.metadata = m;
    }

    public HudVisibilityFilter getFilter() {
        return this.filter;
    }

    public HudVisibility getMetadata() {
        return this.metadata;
    }

    public Component getComponent() {
        return Component.translatable((String)this.filter.getNameKey());
    }

    public String getName() {
        return GuiUtils.getTranslatable((String)this.filter.getNameKey());
    }

    public String getId() {
        return this.metadata.value();
    }
}

