/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.math.geometry.Vec2;
import dev.boxadactle.boxlib.math.mathutils.NumberFormatter;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.WorldColors;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import oshi.util.tuples.Triplet;

@HudDisplayMode(value="default")
public class DefaultRenderer
implements HudRenderer {
    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        NumberFormatter<Double> formatter = this.genFormatter();
        Triplet<String, String, String> player = this.roundPosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), CoordinatesDisplay.getConfig().decimalPlaces);
        Vec2<Integer> chunkPos = pos.position.getChunkPos();
        int p = this.config().padding;
        int tp = this.config().textPadding;
        ColumnLayout hud = new ColumnLayout(0, 0, tp);
        RowLayout row1 = new RowLayout(0, 0, tp);
        ParagraphComponent row2 = new ParagraphComponent(0, new Component[0]);
        if (this.config().renderXYZ) {
            Component xtext = this.definition(HudRenderer.GlobalTexts.X, this.value((String)player.getA()));
            Component ytext = this.definition(HudRenderer.GlobalTexts.Y, this.value((String)player.getB()));
            Component ztext = this.definition(HudRenderer.GlobalTexts.Z, this.value((String)player.getC()));
            row1.addComponent((LayoutComponent)new ParagraphComponent(0, new Component[]{xtext, ytext, ztext}));
        }
        if (this.config().renderChunkData) {
            Component chunkx = this.definition(HudRenderer.GlobalTexts.CHUNK_X, this.value(((Integer)chunkPos.getX()).toString()));
            Component chunkz = this.definition(HudRenderer.GlobalTexts.CHUNK_Z, this.value(((Integer)chunkPos.getY()).toString()));
            row1.addComponent((LayoutComponent)new ParagraphComponent(0, new Component[]{chunkx, chunkz}));
        }
        if (this.config().renderDirection) {
            MutableComponent direction = Component.empty().append(this.definition(this.resolveDirection(ModUtil.getDirectionFromYaw(pos.headRot.wrapYaw())))).append(" ").append((Component)(this.config().renderDirectionInt ? this.value("(" + formatter.formatDecimal((Number)pos.headRot.wrapYaw()) + ")") : Component.empty()));
            row2.add((Component)direction);
        }
        if (this.config().renderBiome || this.config().renderDimension) {
            Component biomeString = ModUtil.getBiomeComponent(pos.world.getBiomeKey(), pos.world.getBiome(), this.config().biomeColors, this.config().dataColor);
            Component biome = this.definition(HudRenderer.GlobalTexts.BIOME, biomeString);
            String dimensionstring = pos.world.getDimension(true);
            Component coloredDimensionstring = GuiUtils.colorize((Component)Component.literal((String)dimensionstring), (int)(this.config().biomeColors ? WorldColors.getDimensionColor(dimensionstring, this.config().definitionColor) : this.config().definitionColor));
            Component dimension = this.definition(HudRenderer.GlobalTexts.DIMENSION, coloredDimensionstring);
            MutableComponent biomeDimension = (this.config().renderDimension ? (this.config().renderBiome ? coloredDimensionstring : dimension).copy() : Component.empty()).append((Component)(this.config().renderDimension && this.config().renderBiome ? this.definition(": ") : Component.empty())).append((Component)(this.config().renderBiome ? (this.config().renderDimension ? biomeString : biome) : Component.empty()));
            row2.add((Component)biomeDimension);
        }
        if (this.config().renderMCVersion) {
            Component mcversion = this.definition("version", this.value(ClientUtils.getGameVersion()));
            row2.add(mcversion);
        }
        if (this.config().renderDay) {
            Component day = this.definition(HudRenderer.GlobalTexts.DAY, this.value(Long.toString(pos.world.getDay())));
            row2.add(day);
        }
        hud.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row1));
        hud.addComponent((LayoutComponent)row2);
        return new PaddingLayout(x, y, p, (RenderingLayout)hud);
    }
}

