/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.boxlib.math.mathutils.NumberFormatter;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.position.Position;
import dev.boxadactle.coordinatesdisplay.renderer.SpawnpointRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import oshi.util.tuples.Triplet;

@HudDisplayMode(value="direction", hasChunkData=false, hasBiome=false, hasMCVersion=false, hasDimension=false, hasDay=false)
public class DirectionRenderer
implements HudRenderer {
    private String[] createYawComponents(double yaw) {
        String[][] directions = new String[][]{{"_", "+"}, {"-", "+"}, {"-", "_"}, {"-", "-"}, {"_", "-"}, {"+", "-"}, {"+", "_"}, {"+", "+"}};
        return directions[(int)Math.round(yaw / 45.0) & 7];
    }

    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        NumberFormatter<Double> formatter = this.genFormatter();
        Triplet<String, String, String> player = this.roundPosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), CoordinatesDisplay.getConfig().decimalPlaces);
        ColumnLayout hud = new ColumnLayout(0, 0, this.config().textPadding);
        RowLayout row = new RowLayout(0, 0, this.config().textPadding * 2);
        if (this.config().renderXYZ) {
            Component xtext = this.definition(HudRenderer.GlobalTexts.X, this.value((String)player.getA()));
            Component ytext = this.definition(HudRenderer.GlobalTexts.Y, this.value((String)player.getB()));
            Component ztext = this.definition(HudRenderer.GlobalTexts.Z, this.value((String)player.getC()));
            row.addComponent((LayoutComponent)new ParagraphComponent(0, new Component[]{xtext, ytext, ztext}));
        }
        SpawnpointRenderer.CompassRenderer compassRenderer = new SpawnpointRenderer.CompassRenderer(pos, new BlockPos(0, 0, 0));
        compassRenderer.size = 28;
        RowLayout r = new RowLayout(0, 0, 0);
        r.addComponent((LayoutComponent)compassRenderer);
        row.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)new PaddingLayout(0, 0, 4, (RenderingLayout)r)));
        hud.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row));
        ParagraphComponent direction = new ParagraphComponent(0, new Component[0]);
        double yaw = pos.headRot.wrapYaw();
        if (this.config().renderDirection) {
            String[] components = this.createYawComponents(yaw);
            Component intText = this.definition((Component)Component.literal((String)(components[0] + " (" + formatter.formatDecimal((Number)compassRenderer.calculateRelativeDirection(pos.position.getBlockPos(), (Vec3<Integer>)new Vec3((Number)0, (Number)0, (Number)0), yaw)) + "\u00b0) " + components[1])));
            String dir = ModUtil.getDirectionFromYaw(yaw);
            Component directionText = this.definition("direction", this.value(this.resolveDirection(dir)), this.value(this.resolveDirection(dir, true)));
            direction.add(intText);
            direction.add(directionText);
        }
        if (this.config().renderDirectionInt) {
            Direction directionFromYaw = Direction.fromYaw(yaw);
            Component yawText = this.definition("yaw", this.value(formatter.formatDecimal((Number)yaw)), this.value(directionFromYaw.component));
            Direction pitchFromYaw = Direction.fromPitch(pos.headRot.wrapPitch());
            Component pitchText = this.definition("pitch", this.value(formatter.formatDecimal((Number)pos.headRot.wrapPitch())), this.value(pitchFromYaw.component));
            direction.add(yawText);
            direction.add(pitchText);
        }
        direction.add(this.definition("rendering3d", this.value(this.config().render3dCompass ? GuiUtils.ON : GuiUtils.OFF)));
        hud.addComponent((LayoutComponent)direction);
        return new PaddingLayout(x, y, this.config().padding, (RenderingLayout)hud);
    }

    private static enum Direction {
        POSITIVE_Z((Component)Component.translatable((String)"hud.coordinatesdisplay.direction.positive", (Object[])new Object[]{"Z"})),
        NEGATIVE_X((Component)Component.translatable((String)"hud.coordinatesdisplay.direction.negative", (Object[])new Object[]{"X"})),
        NEGATIVE_Z((Component)Component.translatable((String)"hud.coordinatesdisplay.direction.negative", (Object[])new Object[]{"Z"})),
        POSITIVE_X((Component)Component.translatable((String)"hud.coordinatesdisplay.direction.positive", (Object[])new Object[]{"X"})),
        POSITIVE_Y((Component)Component.translatable((String)"hud.coordinatesdisplay.direction.positive", (Object[])new Object[]{"Y"})),
        NEGATIVE_Y((Component)Component.translatable((String)"hud.coordinatesdisplay.direction.negative", (Object[])new Object[]{"Y"}));

        public final Component component;

        private Direction(Component component) {
            this.component = component;
        }

        public static Direction fromYaw(double yaw) {
            return Direction.values()[(int)Math.round(yaw / 90.0) & 3];
        }

        public static Direction fromPitch(double pitch) {
            return pitch > 0.0 ? NEGATIVE_Y : POSITIVE_Y;
        }
    }
}

