/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.ModUtil;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.network.chat.Component;
import oshi.util.tuples.Triplet;

@HudDisplayMode(value="line", hasChunkData=false, hasDirectionInt=false, hasBiome=false, hasMCVersion=false, hasDimension=false, hasDay=false)
public class LineRenderer
implements HudRenderer {
    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        Triplet<String, String, String> player = this.roundPosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), CoordinatesDisplay.getConfig().decimalPlaces);
        RowLayout layout = new RowLayout(0, 0, this.config().textPadding);
        if (this.config().renderXYZ) {
            Component xtext = this.definition(HudRenderer.GlobalTexts.X, this.value((String)player.getA()));
            Component ytext = this.definition(HudRenderer.GlobalTexts.Y, this.value((String)player.getB()));
            Component ztext = this.definition(HudRenderer.GlobalTexts.Z, this.value((String)player.getC()));
            RowLayout xyz = new RowLayout(0, 0, 3);
            xyz.addComponent((LayoutComponent)new TextComponent(xtext));
            xyz.addComponent((LayoutComponent)new TextComponent(ytext));
            xyz.addComponent((LayoutComponent)new TextComponent(ztext));
            layout.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)xyz));
        }
        if (this.config().renderDirection) {
            Component direction = this.definition(HudRenderer.GlobalTexts.FACING, this.value(this.resolveDirection(ModUtil.getDirectionFromYaw(pos.headRot.wrapYaw()))));
            layout.addComponent((LayoutComponent)new TextComponent(direction));
        }
        int p = this.config().renderBackground ? this.config().padding : 0;
        return new PaddingLayout(x, y, p, (RenderingLayout)layout);
    }
}

