/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.coordinatesdisplay.renderer;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.boxlib.util.RenderUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import dev.boxadactle.coordinatesdisplay.CoordinatesDisplay;
import dev.boxadactle.coordinatesdisplay.HudDisplayMode;
import dev.boxadactle.coordinatesdisplay.HudRenderer;
import dev.boxadactle.coordinatesdisplay.position.Position;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import oshi.util.tuples.Triplet;

@HudDisplayMode(value="spawnpoint", hasChunkData=false, hasDirection=false, hasDirectionInt=false, hasBiome=false, hasMCVersion=false, hasDimension=false, hasDay=false)
public class SpawnpointRenderer
implements HudRenderer {
    public BlockPos resolveWorldSpawn() {
        try {
            return WorldUtils.getWorld().getRespawnData().pos();
        }
        catch (Exception e) {
            return new BlockPos(0, 0, 0);
        }
    }

    private Tuple<Vec3<Double>, Vec3<Integer>> createRelativePosition(Vec3<Double> playerVec, Vec3<Integer> playerBlock, BlockPos spawn) {
        int spawnX = spawn.getX();
        int spawnY = spawn.getY();
        int spawnZ = spawn.getZ();
        Vec3 relativeVec = new Vec3((Number)((Double)playerVec.getX() - (double)spawnX), (Number)((Double)playerVec.getY() - (double)spawnY), (Number)((Double)playerVec.getZ() - (double)spawnZ));
        Vec3 relativeBlock = new Vec3((Number)((Integer)playerBlock.getX() - spawnX), (Number)((Integer)playerBlock.getY() - spawnY), (Number)((Integer)playerBlock.getZ() - spawnZ));
        return new Tuple((Object)relativeVec, (Object)relativeBlock);
    }

    @Override
    public RenderingLayout renderOverlay(int x, int y, Position pos) {
        BlockPos spawnpoint = this.resolveWorldSpawn();
        ColumnLayout hud = new ColumnLayout(0, 0, this.config().textPadding);
        RowLayout row1 = new RowLayout(0, 0, this.config().textPadding);
        RowLayout row2 = new RowLayout(0, 0, this.config().textPadding);
        if (this.config().renderXYZ) {
            Component playerLabel = this.definition("player", "");
            Triplet<String, String, String> player = this.roundPosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), CoordinatesDisplay.getConfig().decimalPlaces);
            Triplet<Component, Component, Component> xyz = this.createXYZ((String)player.getA(), (String)player.getB(), (String)player.getC());
            ParagraphComponent component = new ParagraphComponent(0, new Component[]{playerLabel, (Component)xyz.getA(), (Component)xyz.getB(), (Component)xyz.getC()});
            row1.addComponent((LayoutComponent)component);
        }
        Component spawnpointLabel = this.definition("worldSpawn", "");
        Triplet<Component, Component, Component> spawnpointXYZ = this.createXYZ(spawnpoint.getX(), spawnpoint.getY(), spawnpoint.getZ());
        ParagraphComponent component = new ParagraphComponent(0, new Component[]{spawnpointLabel, (Component)spawnpointXYZ.getA(), (Component)spawnpointXYZ.getB(), (Component)spawnpointXYZ.getC()});
        row1.addComponent((LayoutComponent)component);
        Component relativeLabel = this.definition("relative", "");
        Tuple<Vec3<Double>, Vec3<Integer>> relativePos = this.createRelativePosition(pos.position.getPlayerPos(), pos.position.getBlockPos(), new BlockPos(spawnpoint.getX(), spawnpoint.getY(), spawnpoint.getZ()));
        Triplet<String, String, String> relative = this.roundPosition((Vec3<Double>)((Vec3)relativePos.getA()), (Vec3<Integer>)((Vec3)relativePos.getB()), CoordinatesDisplay.getConfig().decimalPlaces);
        Triplet<Component, Component, Component> relativeXYZ = this.createXYZ((String)relative.getA(), (String)relative.getB(), (String)relative.getC());
        ParagraphComponent component2 = new ParagraphComponent(0, new Component[]{relativeLabel, (Component)relativeXYZ.getA(), (Component)relativeXYZ.getB(), (Component)relativeXYZ.getC()});
        row2.addComponent((LayoutComponent)component2);
        CompassRenderer compass = new CompassRenderer(pos, spawnpoint);
        row2.addComponent((LayoutComponent)compass);
        hud.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row1));
        hud.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row2));
        return new PaddingLayout(x, y, this.config().padding, (RenderingLayout)hud);
    }

    public static class CompassRenderer
    extends LayoutComponent<Position> {
        BlockPos spawnpoint;
        public int size = 32;

        public CompassRenderer(Position component, BlockPos spawnpoint) {
            super((Object)component);
            this.spawnpoint = spawnpoint;
        }

        public int getWidth() {
            return this.size;
        }

        public int getHeight() {
            return this.size;
        }

        public double calculateRelativeDirection(Vec3<Integer> pos1, Vec3<Integer> pos2, double yaw) {
            int x = (Integer)pos2.getX() - (Integer)pos1.getX();
            int z = (Integer)pos2.getZ() - (Integer)pos1.getZ();
            double theta = Math.atan2(z, x);
            double startDirection = Math.toDegrees(theta) + 180.0;
            double relativeDirection = startDirection - yaw;
            if (relativeDirection < 0.0) {
                relativeDirection += 360.0;
            }
            return Mth.wrapDegrees((double)((relativeDirection -= 180.0) - 90.0));
        }

        private ResourceLocation resolveCompassTexture(double d) {
            double degrees = Mth.wrapDegrees((double)(d + 180.0));
            double range360 = degrees + 180.0;
            double range1 = range360 / 360.0;
            String[] textures = new String[]{"compass_16", "compass_17", "compass_18", "compass_19", "compass_20", "compass_21", "compass_22", "compass_23", "compass_24", "compass_25", "compass_26", "compass_27", "compass_28", "compass_29", "compass_30", "compass_31", "compass_00", "compass_01", "compass_02", "compass_03", "compass_04", "compass_05", "compass_06", "compass_07", "compass_08", "compass_09", "compass_10", "compass_11", "compass_12", "compass_13", "compass_14", "compass_15", "compass_16"};
            String texture = "textures/item/" + textures[(int)(range1 * (double)textures.length)] + ".png";
            return ResourceLocation.withDefaultNamespace((String)texture);
        }

        public void render(GuiGraphics guiGraphics, int x, int y) {
            double degrees = this.calculateRelativeDirection(((Position)this.component).position.getBlockPos(), (Vec3<Integer>)new Vec3((Number)this.spawnpoint.getX(), (Number)this.spawnpoint.getY(), (Number)this.spawnpoint.getZ()), ((Position)this.component).headRot.wrapYaw());
            RenderUtils.drawTexture((ResourceLocation)this.resolveCompassTexture(degrees), (GuiGraphics)guiGraphics, (int)x, (int)y, (int)this.size, (int)this.size, (int)0, (int)0);
        }
    }
}

