/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoshinofw.createbuildstonetoolkit.level.blocks;

import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyBlock;
import com.github.hoshinofw.buildstonetoolkit.common.level.blocks.IProxyEntityBlock;
import com.github.hoshinofw.buildstonetoolkit.util.Util;
import com.github.hoshinofw.createbuildstonetoolkit.level.blocks.entities.AssemblyProxyBlockEntity;
import com.github.hoshinofw.createbuildstonetoolkit.registries.CBTBlockEntities;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class AssemblyProxyBlock
extends Block
implements EntityBlock,
IProxyBlock,
IProxyEntityBlock,
IWrenchable {
    public AssemblyProxyBlock(BlockBehaviour.Properties arg) {
        super(arg);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWER_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWER_LEVEL});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new AssemblyProxyBlockEntity(pos, state);
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos pos2, boolean bl) {
        super.neighborChanged(state, level, pos, block, pos2, bl);
    }

    public void onPlace(@NotNull BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean bl) {
        super.onPlace(oldState, level, pos, newState, bl);
    }

    public boolean shouldPreserveTargetAbsPos(@NotNull Level level, @NotNull PistonMovingBlockEntity pistonMovingBlockEntity, BlockPos blockPos, BlockPos blockPos1, Direction direction) {
        return false;
    }

    public boolean shouldTransferMovement(BlockPos blockPos, BlockState blockState, Direction direction) {
        return false;
    }

    @Nullable
    public BlockPos getLinkedBlockPos(@NotNull Level level, BlockPos blockPos) {
        Optional optionalBE = level.getBlockEntity(blockPos, CBTBlockEntities.ASSEMBLY_PROXY.get());
        return optionalBE.map(AssemblyProxyBlockEntity::getTargetBlockPos).orElse(null);
    }

    public Util.FailableResult<BlockPos> parsePos(@NotNull Level level, BlockPos proxyPos, BlockPos inputPos) {
        BlockPos outputPos = inputPos.subtract((Vec3i)proxyPos);
        return new Util.FailableResult((Object)outputPos, true);
    }

    public boolean setLinkedRelPos(@NotNull Level level, BlockPos pos, BlockPos newRelativeTargetPos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof AssemblyProxyBlockEntity) {
            AssemblyProxyBlockEntity apBE = (AssemblyProxyBlockEntity)be;
            apBE.setTargetOffset(newRelativeTargetPos);
            apBE.setChanged();
            level.sendBlockUpdated(pos, apBE.getBlockState(), apBE.getBlockState(), 3);
            return true;
        }
        return false;
    }

    public void offsetLinkedPos(Level level, BlockPos blockPos, BlockState blockState, Direction direction) {
        Optional optionalBE = level.getBlockEntity(blockPos, CBTBlockEntities.ASSEMBLY_PROXY.get());
        if (optionalBE.isPresent()) {
            AssemblyProxyBlockEntity blockEntity = (AssemblyProxyBlockEntity)((Object)optionalBE.get());
            blockEntity.setTargetOffset(blockEntity.getTargetOffset().relative(direction.getOpposite()));
        }
    }

    public void offsetLinkedPos(Level level, BlockPos blockPos, BlockState blockState, Direction direction, int i) {
        Optional optionalBE = level.getBlockEntity(blockPos, CBTBlockEntities.ASSEMBLY_PROXY.get());
        if (optionalBE.isPresent()) {
            AssemblyProxyBlockEntity blockEntity = (AssemblyProxyBlockEntity)((Object)optionalBE.get());
            blockEntity.setTargetOffset(blockEntity.getTargetOffset().relative(direction.getOpposite(), i));
        }
    }

    public BlockState computeNewStateWithPreservedTargetAbsPos(Level level, BlockPos blockPos, BlockState oldState, Direction direction) {
        return oldState;
    }

    public CompoundTag computeNewNBTWithPreservedTargetAbsPos(Level level, BlockPos blockPos, BlockState blockState, @Nullable CompoundTag compoundTag, Direction direction) {
        return compoundTag;
    }

    public BlockState computeNewStateWithPreservedTargetAbsPos(Level level, BlockPos blockPos, CompoundTag compoundTag, BlockState oldState, Direction direction) {
        return oldState;
    }
}

