/*
 * Decompiled with CFR 0.152.
 */
package www.wheelershigley.me.trade_experience.config;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.class_3545;
import www.wheelershigley.me.trade_experience.TradeExperience;
import www.wheelershigley.me.trade_experience.config.Configuration;

public class Configurations {
    private final File configurationFile;
    private final String configurationFileName;
    private HashMap<String, Configuration<?>> configurations = new HashMap();

    public Configurations(File configurationFile, String fileName) {
        this.configurationFile = configurationFile;
        this.configurationFileName = fileName;
    }

    public boolean addConfiguration(Configuration<?> configuration) {
        if (this.configurations.containsKey(configuration.getName())) {
            return false;
        }
        this.configurations.put(configuration.getName(), configuration);
        return true;
    }

    public Configuration<?> getConfiguration(String key) {
        return this.configurations.get(key);
    }

    private void createConfigurationFile() throws IOException {
        if (this.configurationFile.exists() && !this.configurationFile.isDirectory()) {
            return;
        }
        this.configurationFile.getParentFile().mkdirs();
        Files.createFile(this.configurationFile.toPath(), new FileAttribute[0]);
        StringBuilder configBuilder = new StringBuilder();
        for (Map.Entry<String, Configuration<?>> configuration : this.configurations.entrySet()) {
            configBuilder.append(configuration.getValue().getDefaultConfiguration()).append("\r\n");
        }
        configBuilder.append("\r\n");
        PrintWriter writer = new PrintWriter(this.configurationFile, StandardCharsets.UTF_8);
        writer.write(configBuilder.toString());
        writer.close();
    }

    private static Configuration<?> parseConfiguration(String line) {
        String[] splitPair = line.split(":");
        if (splitPair.length != 2) {
            return null;
        }
        class_3545 unparsedPair = new class_3545((Object)splitPair[0].trim(), (Object)splitPair[1].trim());
        if (((String)unparsedPair.method_15441()).equalsIgnoreCase("true") || ((String)unparsedPair.method_15441()).equalsIgnoreCase("false")) {
            return new Configuration<Boolean>((String)unparsedPair.method_15442(), Boolean.parseBoolean((String)unparsedPair.method_15441()));
        }
        if (((String)unparsedPair.method_15441()).matches("^[-+0-9]*$")) {
            return new Configuration<Long>((String)unparsedPair.method_15442(), Long.parseLong((String)unparsedPair.method_15441()));
        }
        if (((String)unparsedPair.method_15441()).matches("^[-+0-9.]*$")) {
            return new Configuration<Double>((String)unparsedPair.method_15442(), Double.parseDouble((String)unparsedPair.method_15441()));
        }
        return new Configuration<String>((String)unparsedPair.method_15442(), (String)unparsedPair.method_15441());
    }

    private static Configurations loadConfigurations(File configurationFile, String configurationFileName) throws IOException {
        Configurations configurations = new Configurations(configurationFile, configurationFileName);
        Scanner reader = new Scanner(configurations.configurationFile);
        int lineNumber = 1;
        while (reader.hasNextLine()) {
            Configuration<?> currentConfiguration = Configurations.parseConfiguration(reader.nextLine());
            if (currentConfiguration != null) {
                configurations.addConfiguration(currentConfiguration);
            }
            ++lineNumber;
        }
        return configurations;
    }

    public String toString() {
        StringBuilder configurationsBuilder = new StringBuilder();
        for (Map.Entry<String, Configuration<?>> configuration : this.configurations.entrySet()) {
            configurationsBuilder.append(configuration.getValue().getName()).append(": ").append(configuration.getValue().getValue()).append("; ");
        }
        return configurationsBuilder.toString();
    }

    public void reload() {
        Configurations measuredConfigurations;
        if (!this.configurationFile.exists()) {
            try {
                this.createConfigurationFile();
            }
            catch (IOException ioException) {
                TradeExperience.LOGGER.error("Error creating configuration file.");
            }
        }
        try {
            measuredConfigurations = Configurations.loadConfigurations(this.configurationFile, this.configurationFileName);
        }
        catch (IOException ioException) {
            measuredConfigurations = null;
            TradeExperience.LOGGER.error("Failed to load configurations.");
        }
        ArrayList<class_3545> missingConfigurations = new ArrayList<class_3545>();
        for (Map.Entry<String, Configuration<?>> configuration : this.configurations.entrySet()) {
            boolean add_current_configuration = false;
            if (measuredConfigurations == null) {
                add_current_configuration = true;
            } else if (measuredConfigurations.configurations.containsKey(configuration.getKey())) {
                TradeExperience.configurations.getConfiguration(configuration.getKey()).setValue(measuredConfigurations.getConfiguration(configuration.getKey()).getValue());
            } else {
                add_current_configuration = true;
            }
            if (measuredConfigurations != null && measuredConfigurations.configurations.containsKey(configuration.getKey()) && !measuredConfigurations.configurations.get(configuration.getKey()).getValue().getClass().equals(this.configurations.get(configuration.getKey()).getDefaultValue().getClass())) {
                TradeExperience.LOGGER.warn("Type mismatch for configuration \"" + this.configurations.get(configuration.getKey()).getName() + "\"; set to default value, \"" + this.configurations.get(configuration.getKey()).getDefaultValue().toString() + "\".");
                this.configurations.get(configuration.getKey()).setValue(this.configurations.get(configuration.getKey()).getDefaultValue());
            }
            if (!add_current_configuration) continue;
            missingConfigurations.add(new class_3545((Object)configuration.getKey(), configuration.getValue()));
        }
        if (this.configurationFile.exists()) {
            Scanner reader;
            try {
                reader = new Scanner(this.configurationFile);
            }
            catch (IOException ioException) {
                TradeExperience.LOGGER.error("Error reading configuration file.");
                return;
            }
            StringBuilder fileContentBuilder = new StringBuilder();
            try {
                fileContentBuilder.append(Files.readString(Paths.get(this.configurationFile.getAbsolutePath(), new String[0])));
            }
            catch (IOException ioException) {
                TradeExperience.LOGGER.error("Error reading configuration file.");
                return;
            }
            for (class_3545 missingConfiguration : missingConfigurations) {
                fileContentBuilder.append("\r\n").append(((Configuration)missingConfiguration.method_15441()).getDefaultConfiguration());
            }
            reader.close();
            if (!missingConfigurations.isEmpty()) {
                PrintWriter writer;
                try {
                    writer = new PrintWriter(this.configurationFile, StandardCharsets.UTF_8);
                }
                catch (IOException ioException) {
                    TradeExperience.LOGGER.error("Error writing configuration file.");
                    return;
                }
                writer.write(fileContentBuilder.toString());
                writer.close();
            }
        } else {
            try {
                this.createConfigurationFile();
            }
            catch (IOException ioException) {
                TradeExperience.LOGGER.error("Error creating configuration file.");
            }
        }
    }
}

