/*
 * Decompiled with CFR 0.152.
 */
package www.wheelershigley.me.trade_experience.helpers;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import www.wheelershigley.me.trade_experience.Trade;
import www.wheelershigley.me.trade_experience.TradeExperience;
import www.wheelershigley.me.trade_experience.commands.PlayersSuggestionProvider;
import www.wheelershigley.me.trade_experience.commands.ReloadSuggestionProvider;
import www.wheelershigley.me.trade_experience.helpers.ExperienceHelper;
import www.wheelershigley.me.trade_experience.helpers.MessageHelper;

public class Registrations {
    private static long delta_time = 0L;
    private static final Predicate<class_2168> isServerOrOperator = source -> {
        if (!source.method_43737()) {
            return true;
        }
        class_3222 sourcePlayer = source.method_44023();
        if (sourcePlayer == null) {
            return false;
        }
        return sourcePlayer.field_13995.method_3760().method_14569(sourcePlayer.method_7334());
    };

    public static void registerPlayerClickListener() {
        UseEntityCallback.EVENT.register((player, world, hand, target, hitResult) -> {
            if (!(target instanceof class_3222)) {
                return null;
            }
            if (target.method_5715()) {
                return null;
            }
            UUID traderID = player.method_5667();
            Trade trade = new Trade(player.method_5667(), ((class_1657)target).method_5667(), world, world.method_8510());
            boolean isNewTrade = true;
            if (TradeExperience.activeTrades.containsKey(traderID)) {
                if (TradeExperience.activeTrades.get(traderID).getReciever() != target.method_5667()) {
                    TradeExperience.activeTrades.replace(traderID, trade);
                } else {
                    isNewTrade = false;
                }
            } else {
                TradeExperience.activeTrades.put(traderID, trade);
            }
            if (isNewTrade) {
                MessageHelper.sendInitiationTellRaw((class_3222)target, (class_3222)player);
                MessageHelper.sendMessage((class_3222)player, "trade_experience.text.trade", false, target.method_5477().getString());
            }
            return null;
        });
    }

    public static void registerCheckTimeoutsEachTick() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (Map.Entry<UUID, Trade> activeTrade : TradeExperience.activeTrades.entrySet()) {
                delta_time = activeTrade.getValue().getWorld().method_8510() - activeTrade.getValue().getTime();
                if (TradeExperience.cooldown > delta_time) continue;
                MessageHelper.sendTradeTimeOutChatMessage(server.method_3760().method_14602(activeTrade.getValue().getSender()), server.method_3760().method_14602(activeTrade.getValue().getReciever()));
                TradeExperience.activeTrades.remove(activeTrade.getKey());
            }
        });
    }

    public static void registerCommands() {
        Command balanceCommand = context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                return 1;
            }
            MessageHelper.sendMessage(player, "trade_experience.text.balance", false, Integer.toString(ExperienceHelper.levelToPoints(player.field_7520) + ExperienceHelper.getExperiencePoints((class_1657)player)), TradeExperience.experienceName);
            return 0;
        };
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"balance").executes(balanceCommand));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"bal").executes(balanceCommand));
        });
        Command paymentCommand = context -> {
            class_3222 sourcePlayer = ((class_2168)context.getSource()).method_44023();
            if (sourcePlayer == null) {
                return 1;
            }
            class_3222 targetPlayer = sourcePlayer.field_13995.method_3760().method_14566(StringArgumentType.getString((CommandContext)context, (String)"target"));
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            Trade.performTrade(sourcePlayer, targetPlayer, amount);
            return 0;
        };
        Command incorrectPaymentCommand = context -> {
            class_3222 sourcePlayer = ((class_2168)context.getSource()).method_44023();
            if (sourcePlayer == null) {
                return 1;
            }
            sourcePlayer.method_64398((class_2561)class_2561.method_43470((String)class_2561.method_43471((String)"trade_experience.command.text.unknown_amount").getString()));
            return 0;
        };
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"pay").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new PlayersSuggestionProvider()).executes(incorrectPaymentCommand)).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(paymentCommand)))));
        Command tradeExperienceCommand = context -> {
            String sublet = StringArgumentType.getString((CommandContext)context, (String)"sublet");
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append('<').append(class_2561.method_43471((String)"trade_experience.text.mod_name").getString()).append("> ");
            if (player != null && player.method_5691() == 0) {
                messageBuilder.append(class_2561.method_43471((String)"trade_experience.command.text.insufficient_permission").getString());
            } else {
                messageBuilder.append(class_2561.method_43471((String)"trade_experience.command.text.reloaded").getString());
            }
            if (sublet.equals("reload")) {
                TradeExperience.reload();
                if (player != null) {
                    player.method_64398((class_2561)class_2561.method_43470((String)messageBuilder.toString()));
                }
                return 0;
            }
            return 1;
        };
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trade_experience".toLowerCase().replaceAll("_", "")).requires(isServerOrOperator)).then(class_2170.method_9244((String)"sublet", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ReloadSuggestionProvider()).executes(tradeExperienceCommand))));
    }
}

