/*
 * Decompiled with CFR 0.152.
 */
package fabric.dev.mrsnowy.teleport_commands.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import fabric.dev.mrsnowy.teleport_commands.Constants;
import fabric.dev.mrsnowy.teleport_commands.common.NamedLocation;
import fabric.dev.mrsnowy.teleport_commands.common.Player;
import fabric.dev.mrsnowy.teleport_commands.storage.StorageManager;
import fabric.dev.mrsnowy.teleport_commands.suggestions.HomeSuggestionProvider;
import fabric.dev.mrsnowy.teleport_commands.utils.tools;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class home {
    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.SetHome(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while setting a home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.setError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires(source -> source.method_44023() != null)).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.GoHome(player, "");
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while going home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.goError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).requires(source -> source.method_44023() != null)).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.GoHome(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while going to a specific home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.goError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.DeleteHome(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while deleting a home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.deleteError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"renamehome").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).then(class_2170.method_9244((String)"newName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            String newName = StringArgumentType.getString((CommandContext)context, (String)"newName");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.RenameHome(player, name, newName);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while renaming a home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.renameError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        }))));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"defaulthome").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.SetDefaultHome(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while setting the default home! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.defaultError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"homes").requires(source -> source.method_44023() != null)).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                home.PrintHomes(player);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while printing the homes! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.homes.error", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        }));
    }

    private static void SetHome(class_3222 player, String homeName) throws Exception {
        NamedLocation warp2;
        homeName = homeName.toLowerCase();
        class_2338 blockPos = player.method_24515();
        String worldString = player.method_51469().method_27983().method_29177().toString();
        Player playerStorage = StorageManager.STORAGE.addPlayer(player.method_5845());
        boolean homeExists = playerStorage.addHome(warp2 = new NamedLocation(homeName, blockPos, worldString));
        if (homeExists) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.exists", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        } else {
            if (playerStorage.getHomes().size() == 1) {
                playerStorage.setDefaultHome(homeName);
            }
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.set", player, new class_5250[0]), true);
        }
    }

    private static void GoHome(class_3222 player, String homeName) throws Exception {
        Optional<NamedLocation> optionalHome;
        homeName = homeName.toLowerCase();
        Optional<Player> optionalPlayerStorage = StorageManager.STORAGE.getPlayer(player.method_5845());
        if (optionalPlayerStorage.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new class_5250[0]).method_27692(class_124.field_1075), true);
            return;
        }
        Player playerStorage = optionalPlayerStorage.get();
        if (homeName.isEmpty()) {
            String defaultHome = playerStorage.getDefaultHome();
            if (defaultHome.isEmpty()) {
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.defaultNone", player, new class_5250[0]).method_27692(class_124.field_1075), true);
                return;
            }
            homeName = defaultHome;
        }
        if ((optionalHome = playerStorage.getHome(homeName)).isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new class_5250[0]).method_27692(class_124.field_1075), true);
            return;
        }
        NamedLocation home2 = optionalHome.get();
        Optional<class_3218> optionalWorld = home2.getWorld();
        if (optionalWorld.isEmpty()) {
            Constants.LOGGER.warn("({}) Error while going to the home \"{}\"! \nCouldn't find a world with the id: \"{}\" \nAvailable worlds: {}", new Object[]{player.method_5477().getString(), home2.getName(), home2.getWorldString(), tools.getWorldIds()});
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.common.worldNotFound", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
            return;
        }
        class_3218 homeWorld = optionalWorld.get();
        class_2338 teleportBlockPos = home2.getBlockPos();
        if (player.method_24515().equals((Object)teleportBlockPos) && player.method_37908() == homeWorld) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.goSame", player, new class_5250[0]).method_27692(class_124.field_1075), true);
        } else {
            class_243 teleportPos = new class_243((double)teleportBlockPos.method_10263() + 0.5, (double)teleportBlockPos.method_10264(), (double)teleportBlockPos.method_10260() + 0.5);
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.go", player, new class_5250[0]), true);
            tools.Teleporter(player, homeWorld, teleportPos);
        }
    }

    private static void DeleteHome(class_3222 player, String homeName) throws Exception {
        homeName = homeName.toLowerCase();
        Optional<Player> optionalPlayerStorage = StorageManager.STORAGE.getPlayer(player.method_5845());
        if (optionalPlayerStorage.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new class_5250[0]).method_27692(class_124.field_1075), true);
            return;
        }
        Player playerStorage = optionalPlayerStorage.get();
        Optional<NamedLocation> optionalHome = playerStorage.getHome(homeName);
        if (optionalHome.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
            return;
        }
        playerStorage.deleteHome(optionalHome.get());
        if (playerStorage.getDefaultHome().equals(homeName)) {
            playerStorage.setDefaultHome("");
        }
        player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.delete", player, new class_5250[0]), true);
    }

    private static void RenameHome(class_3222 player, String homeName, String newHomeName) throws Exception {
        homeName = homeName.toLowerCase();
        newHomeName = newHomeName.toLowerCase();
        Optional<Player> optionalPlayerStorage = StorageManager.STORAGE.getPlayer(player.method_5845());
        if (optionalPlayerStorage.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new class_5250[0]).method_27692(class_124.field_1075), true);
            return;
        }
        Player playerStorage = optionalPlayerStorage.get();
        if (playerStorage.getHome(newHomeName).isPresent()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.common.nameExists", player, new class_5250[0]).method_27692(class_124.field_1061), true);
            return;
        }
        Optional<NamedLocation> optionalHome = playerStorage.getHome(homeName);
        if (optionalHome.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
            return;
        }
        optionalHome.get().setName(newHomeName);
        if (playerStorage.getDefaultHome().equals(homeName)) {
            playerStorage.setDefaultHome(newHomeName);
        }
        player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.rename", player, new class_5250[0]), true);
    }

    private static void SetDefaultHome(class_3222 player, String homeName) throws Exception {
        homeName = homeName.toLowerCase();
        Optional<Player> optionalPlayerStorage = StorageManager.STORAGE.getPlayer(player.method_5845());
        if (optionalPlayerStorage.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new class_5250[0]).method_27692(class_124.field_1075), true);
            return;
        }
        Player playerStorage = optionalPlayerStorage.get();
        if (playerStorage.getHome(homeName).isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
            return;
        }
        if (playerStorage.getDefaultHome().equals(homeName)) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.defaultSame", player, new class_5250[0]).method_27692(class_124.field_1075), true);
            return;
        }
        playerStorage.setDefaultHome(homeName);
        player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.default", player, new class_5250[0]), true);
    }

    private static void PrintHomes(class_3222 player) throws Exception {
        Optional<Player> optionalPlayerStorage = StorageManager.STORAGE.getPlayer(player.method_5845());
        if (optionalPlayerStorage.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new class_5250[0]).method_27692(class_124.field_1075), true);
            return;
        }
        Player playerStorage = optionalPlayerStorage.get();
        List<NamedLocation> homes = playerStorage.getHomes();
        if (homes.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new class_5250[0]).method_27692(class_124.field_1075), true);
            return;
        }
        class_5250 message = class_2561.method_43473();
        message.method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.homes.homes", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        for (NamedLocation currentHome : homes) {
            String name = String.format("  - %s", currentHome.getName());
            String coords = String.format("[X%d Y%d Z%d]", currentHome.getX(), currentHome.getY(), currentHome.getZ());
            String dimension = String.format(" [%s]", currentHome.getWorldString());
            message.method_27693("\n");
            message.method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075));
            if (playerStorage.getDefaultHome().equals(currentHome.getName())) {
                message.method_27693(" ").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.default", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
            }
            message.method_27693("\n");
            message.method_10852((class_2561)class_2561.method_43470((String)"     | ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)coords).method_27692(class_124.field_1076).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, String.format("X%d Y%d Z%d", currentHome.getX(), currentHome.getY(), currentHome.getZ())))).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)tools.getTranslatedText("commands.teleport_commands.common.hoverCopy", player, new class_5250[0]))))).method_10852((class_2561)class_2561.method_43470((String)dimension).method_27692(class_124.field_1064).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, currentHome.getWorldString()))).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)tools.getTranslatedText("commands.teleport_commands.common.hoverCopy", player, new class_5250[0])))));
            message.method_27693("\n");
            message.method_10852((class_2561)class_2561.method_43470((String)"     | ").method_27692(class_124.field_1075)).method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.tp", player, new class_5250[0]).method_27692(class_124.field_1060).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/home \"%s\"", currentHome.getName()))))).method_27693(" ").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.rename", player, new class_5250[0]).method_27692(class_124.field_1078).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, String.format("/renamehome \"%s\" ", currentHome.getName()))))).method_27693(" ");
            if (!playerStorage.getDefaultHome().equals(currentHome.getName())) {
                message.method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.defaultPrompt", player, new class_5250[0]).method_27692(class_124.field_1062).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/defaulthome \"%s\"", currentHome.getName()))))).method_27693(" ");
            }
            message.method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.delete", player, new class_5250[0]).method_27692(class_124.field_1061).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, String.format("/delhome \"%s\"", currentHome.getName())))));
            message.method_27693("\n");
        }
        player.method_7353((class_2561)message, false);
    }
}

