/*
 * Decompiled with CFR 0.152.
 */
package neoforge.dev.mrsnowy.teleport_commands.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.List;
import java.util.Optional;
import neoforge.dev.mrsnowy.teleport_commands.Constants;
import neoforge.dev.mrsnowy.teleport_commands.common.NamedLocation;
import neoforge.dev.mrsnowy.teleport_commands.common.Player;
import neoforge.dev.mrsnowy.teleport_commands.storage.StorageManager;
import neoforge.dev.mrsnowy.teleport_commands.suggestions.HomeSuggestionProvider;
import neoforge.dev.mrsnowy.teleport_commands.utils.tools;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class home {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sethome").requires(source -> source.getPlayer() != null)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                home.SetHome(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while setting a home! => ", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.setError", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"home").requires(source -> source.getPlayer() != null)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                home.GoHome(player, "");
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while going home! => ", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.goError", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).requires(source -> source.getPlayer() != null)).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                home.GoHome(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while going to a specific home! => ", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.goError", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delhome").requires(source -> source.getPlayer() != null)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                home.DeleteHome(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while deleting a home! => ", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.deleteError", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"renamehome").requires(source -> source.getPlayer() != null)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).then(Commands.argument((String)"newName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            String newName = StringArgumentType.getString((CommandContext)context, (String)"newName");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                home.RenameHome(player, name, newName);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while renaming a home! => ", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.renameError", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        }))));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"defaulthome").requires(source -> source.getPlayer() != null)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                home.SetDefaultHome(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while setting the default home! => ", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.defaultError", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"homes").requires(source -> source.getPlayer() != null)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                home.PrintHomes(player);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while printing the homes! => ", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.homes.error", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        }));
    }

    private static void SetHome(ServerPlayer player, String homeName) throws Exception {
        NamedLocation warp2;
        homeName = homeName.toLowerCase();
        BlockPos blockPos = player.blockPosition();
        String worldString = player.serverLevel().dimension().location().toString();
        Player playerStorage = StorageManager.STORAGE.addPlayer(player.getStringUUID());
        boolean homeExists = playerStorage.addHome(warp2 = new NamedLocation(homeName, blockPos, worldString));
        if (homeExists) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.exists", player, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
        } else {
            if (playerStorage.getHomes().size() == 1) {
                playerStorage.setDefaultHome(homeName);
            }
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.set", player, new MutableComponent[0]), true);
        }
    }

    private static void GoHome(ServerPlayer player, String homeName) throws Exception {
        Optional<NamedLocation> optionalHome;
        homeName = homeName.toLowerCase();
        Optional<Player> optionalPlayerStorage = StorageManager.STORAGE.getPlayer(player.getStringUUID());
        if (optionalPlayerStorage.isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
            return;
        }
        Player playerStorage = optionalPlayerStorage.get();
        if (homeName.isEmpty()) {
            String defaultHome = playerStorage.getDefaultHome();
            if (defaultHome.isEmpty()) {
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.defaultNone", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
                return;
            }
            homeName = defaultHome;
        }
        if ((optionalHome = playerStorage.getHome(homeName)).isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
            return;
        }
        NamedLocation home2 = optionalHome.get();
        Optional<ServerLevel> optionalWorld = home2.getWorld();
        if (optionalWorld.isEmpty()) {
            Constants.LOGGER.warn("({}) Error while going to the home \"{}\"! \nCouldn't find a world with the id: \"{}\" \nAvailable worlds: {}", new Object[]{player.getName().getString(), home2.getName(), home2.getWorldString(), tools.getWorldIds()});
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.common.worldNotFound", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
            return;
        }
        ServerLevel homeWorld = optionalWorld.get();
        BlockPos teleportBlockPos = home2.getBlockPos();
        if (player.blockPosition().equals((Object)teleportBlockPos) && player.level() == homeWorld) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.goSame", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
        } else {
            Vec3 teleportPos = new Vec3((double)teleportBlockPos.getX() + 0.5, (double)teleportBlockPos.getY(), (double)teleportBlockPos.getZ() + 0.5);
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.go", player, new MutableComponent[0]), true);
            tools.Teleporter(player, homeWorld, teleportPos);
        }
    }

    private static void DeleteHome(ServerPlayer player, String homeName) throws Exception {
        homeName = homeName.toLowerCase();
        Optional<Player> optionalPlayerStorage = StorageManager.STORAGE.getPlayer(player.getStringUUID());
        if (optionalPlayerStorage.isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
            return;
        }
        Player playerStorage = optionalPlayerStorage.get();
        Optional<NamedLocation> optionalHome = playerStorage.getHome(homeName);
        if (optionalHome.isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
            return;
        }
        playerStorage.deleteHome(optionalHome.get());
        if (playerStorage.getDefaultHome().equals(homeName)) {
            playerStorage.setDefaultHome("");
        }
        player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.delete", player, new MutableComponent[0]), true);
    }

    private static void RenameHome(ServerPlayer player, String homeName, String newHomeName) throws Exception {
        homeName = homeName.toLowerCase();
        newHomeName = newHomeName.toLowerCase();
        Optional<Player> optionalPlayerStorage = StorageManager.STORAGE.getPlayer(player.getStringUUID());
        if (optionalPlayerStorage.isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
            return;
        }
        Player playerStorage = optionalPlayerStorage.get();
        if (playerStorage.getHome(newHomeName).isPresent()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.common.nameExists", player, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
            return;
        }
        Optional<NamedLocation> optionalHome = playerStorage.getHome(homeName);
        if (optionalHome.isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
            return;
        }
        optionalHome.get().setName(newHomeName);
        if (playerStorage.getDefaultHome().equals(homeName)) {
            playerStorage.setDefaultHome(newHomeName);
        }
        player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.rename", player, new MutableComponent[0]), true);
    }

    private static void SetDefaultHome(ServerPlayer player, String homeName) throws Exception {
        homeName = homeName.toLowerCase();
        Optional<Player> optionalPlayerStorage = StorageManager.STORAGE.getPlayer(player.getStringUUID());
        if (optionalPlayerStorage.isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
            return;
        }
        Player playerStorage = optionalPlayerStorage.get();
        if (playerStorage.getHome(homeName).isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.notFound", player, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
            return;
        }
        if (playerStorage.getDefaultHome().equals(homeName)) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.defaultSame", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
            return;
        }
        playerStorage.setDefaultHome(homeName);
        player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.default", player, new MutableComponent[0]), true);
    }

    private static void PrintHomes(ServerPlayer player) throws Exception {
        Optional<Player> optionalPlayerStorage = StorageManager.STORAGE.getPlayer(player.getStringUUID());
        if (optionalPlayerStorage.isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
            return;
        }
        Player playerStorage = optionalPlayerStorage.get();
        List<NamedLocation> homes = playerStorage.getHomes();
        if (homes.isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.homeless", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
            return;
        }
        MutableComponent message = Component.empty();
        message.append((Component)tools.getTranslatedText("commands.teleport_commands.homes.homes", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        for (NamedLocation currentHome : homes) {
            String name = String.format("  - %s", currentHome.getName());
            String coords = String.format("[X%d Y%d Z%d]", currentHome.getX(), currentHome.getY(), currentHome.getZ());
            String dimension = String.format(" [%s]", currentHome.getWorldString());
            message.append("\n");
            message.append((Component)Component.literal((String)name).withStyle(ChatFormatting.AQUA));
            if (playerStorage.getDefaultHome().equals(currentHome.getName())) {
                message.append(" ").append((Component)tools.getTranslatedText("commands.teleport_commands.common.default", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
            }
            message.append("\n");
            message.append((Component)Component.literal((String)"     | ").withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)coords).withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, String.format("X%d Y%d Z%d", currentHome.getX(), currentHome.getY(), currentHome.getZ())))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)tools.getTranslatedText("commands.teleport_commands.common.hoverCopy", player, new MutableComponent[0]))))).append((Component)Component.literal((String)dimension).withStyle(ChatFormatting.DARK_PURPLE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, currentHome.getWorldString()))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)tools.getTranslatedText("commands.teleport_commands.common.hoverCopy", player, new MutableComponent[0])))));
            message.append("\n");
            message.append((Component)Component.literal((String)"     | ").withStyle(ChatFormatting.AQUA)).append((Component)tools.getTranslatedText("commands.teleport_commands.common.tp", player, new MutableComponent[0]).withStyle(ChatFormatting.GREEN).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/home \"%s\"", currentHome.getName()))))).append(" ").append((Component)tools.getTranslatedText("commands.teleport_commands.common.rename", player, new MutableComponent[0]).withStyle(ChatFormatting.BLUE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/renamehome \"%s\" ", currentHome.getName()))))).append(" ");
            if (!playerStorage.getDefaultHome().equals(currentHome.getName())) {
                message.append((Component)tools.getTranslatedText("commands.teleport_commands.common.defaultPrompt", player, new MutableComponent[0]).withStyle(ChatFormatting.DARK_AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/defaulthome \"%s\"", currentHome.getName()))))).append(" ");
            }
            message.append((Component)tools.getTranslatedText("commands.teleport_commands.common.delete", player, new MutableComponent[0]).withStyle(ChatFormatting.RED).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/delhome \"%s\"", currentHome.getName())))));
            message.append("\n");
        }
        player.displayClientMessage((Component)message, false);
    }
}

