/*
 * Decompiled with CFR 0.152.
 */
package neoforge.dev.mrsnowy.teleport_commands.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import neoforge.dev.mrsnowy.teleport_commands.Constants;
import neoforge.dev.mrsnowy.teleport_commands.suggestions.tpaSuggestionProvider;
import neoforge.dev.mrsnowy.teleport_commands.utils.tools;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class tpa {
    public static final ArrayList<tpaArrayClass> tpaList = new ArrayList();

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpa").requires(source -> source.getPlayer() != null)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> {
            ServerPlayer TargetPlayer = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                tpa.tpaCommandHandler(player, TargetPlayer, false);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while sending a tpa request! => ", (Throwable)e);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpahere").requires(source -> source.getPlayer() != null)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> {
            ServerPlayer TargetPlayer = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                tpa.tpaCommandHandler(player, TargetPlayer, true);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while sending a tpahere request! => ", (Throwable)e);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpaaccept").requires(source -> source.getPlayer() != null)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).suggests((SuggestionProvider)new tpaSuggestionProvider()).executes(context -> {
            ServerPlayer TargetPlayer = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                tpa.tpaAccept(player, TargetPlayer);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while accepting a tpa(here) request! => ", (Throwable)e);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpadeny").requires(source -> source.getPlayer() != null)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).suggests((SuggestionProvider)new tpaSuggestionProvider()).executes(context -> {
            ServerPlayer TargetPlayer = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                tpa.tpaDeny(player, TargetPlayer);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while denying a tpa(here) request! => ", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.home.setError", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })));
    }

    private static void tpaCommandHandler(final ServerPlayer FromPlayer, final ServerPlayer ToPlayer, boolean here) throws NullPointerException {
        long playerTpaList = tpaList.stream().filter(tpa2 -> Objects.equals(FromPlayer.getStringUUID(), tpa2.InitPlayer)).filter(tpa2 -> Objects.equals(ToPlayer.getStringUUID(), tpa2.RecPlayer)).count();
        if (FromPlayer == ToPlayer) {
            FromPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.self", FromPlayer, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
        } else if (playerTpaList >= 1L) {
            FromPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.alreadySent", FromPlayer, Component.literal((String)Objects.requireNonNull(ToPlayer.getName().getString(), "ToPlayer name cannot be null")).withStyle(ChatFormatting.BOLD)).withStyle(ChatFormatting.AQUA), true);
        } else {
            final String hereText = here ? "Here" : "";
            final tpaArrayClass tpaRequest = new tpaArrayClass(FromPlayer.getStringUUID(), ToPlayer.getStringUUID(), here);
            String ReceivedFromPlayer = Objects.requireNonNull(FromPlayer.getName().getString(), "FromPlayer name cannot be null");
            String SentToPlayer = Objects.requireNonNull(ToPlayer.getName().getString(), "ToPlayer name cannot be null");
            FromPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.sent", FromPlayer, Component.literal((String)hereText), Component.literal((String)SentToPlayer).withStyle(ChatFormatting.BOLD)), true);
            ToPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.received", ToPlayer, Component.literal((String)hereText), Component.literal((String)ReceivedFromPlayer).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})).withStyle(ChatFormatting.AQUA).append("\n").append((Component)tools.getTranslatedText("commands.teleport_commands.tpa.accept", ToPlayer, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/tpaaccept %s", ReceivedFromPlayer))))).append(" ").append((Component)tools.getTranslatedText("commands.teleport_commands.tpa.deny", ToPlayer, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/tpadeny %s", ReceivedFromPlayer))))), false);
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    boolean successful = tpaList.remove(tpaRequest);
                    if (successful) {
                        FromPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.expired", FromPlayer, Component.literal((String)hereText)).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                        ToPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.expired", ToPlayer, Component.literal((String)hereText)).withStyle(ChatFormatting.WHITE), true);
                    }
                }
            }, 30000L);
        }
    }

    private static void tpaAccept(ServerPlayer FromPlayer, ServerPlayer ToPlayer) {
        if (FromPlayer == ToPlayer) {
            FromPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.self", FromPlayer, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
            return;
        }
        Optional<tpaArrayClass> tpaStorage = tpaList.stream().filter(tpa2 -> Objects.equals(ToPlayer.getStringUUID(), tpa2.InitPlayer)).filter(tpa2 -> Objects.equals(FromPlayer.getStringUUID(), tpa2.RecPlayer)).findFirst();
        if (tpaStorage.isPresent()) {
            ServerPlayer destinationPlayer = tpaStorage.get().here ? ToPlayer : FromPlayer;
            ServerPlayer toSentPlayer = tpaStorage.get().here ? FromPlayer : ToPlayer;
            Optional<BlockPos> teleportData = tools.getSafeBlockPos(destinationPlayer.blockPosition(), destinationPlayer.serverLevel());
            if (teleportData.isPresent()) {
                BlockPos safeBlockPos = teleportData.get();
                Vec3 teleportPos = new Vec3((double)safeBlockPos.getX() + 0.5, (double)safeBlockPos.getY(), (double)safeBlockPos.getZ() + 0.5);
                tools.Teleporter(toSentPlayer, destinationPlayer.serverLevel(), teleportPos);
            } else {
                tools.Teleporter(toSentPlayer, destinationPlayer.serverLevel(), destinationPlayer.position());
            }
            FromPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.accepted", FromPlayer, new MutableComponent[0]).withStyle(ChatFormatting.WHITE), true);
            ToPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.accepted", ToPlayer, new MutableComponent[0]).withStyle(ChatFormatting.GREEN), true);
            tpaList.remove(tpaStorage.get());
        } else {
            FromPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.notFound", FromPlayer, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
        }
    }

    private static void tpaDeny(ServerPlayer FromPlayer, ServerPlayer ToPlayer) {
        if (FromPlayer == ToPlayer) {
            FromPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.self", FromPlayer, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
        } else {
            Optional<tpaArrayClass> tpaStorage = tpaList.stream().filter(tpa2 -> Objects.equals(ToPlayer.getStringUUID(), tpa2.InitPlayer)).filter(tpa2 -> Objects.equals(FromPlayer.getStringUUID(), tpa2.RecPlayer)).findFirst();
            if (tpaStorage.isPresent()) {
                tpaList.remove(tpaStorage.get());
                ToPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.denied", ToPlayer, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                FromPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.denied", FromPlayer, new MutableComponent[0]).withStyle(ChatFormatting.WHITE), true);
            } else {
                FromPlayer.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.tpa.notFound", FromPlayer, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
            }
        }
    }

    public static class tpaArrayClass {
        public final String InitPlayer;
        public final String RecPlayer;
        final boolean here;

        public tpaArrayClass(String initPlayer, String recPlayer, boolean here) {
            this.InitPlayer = initPlayer;
            this.RecPlayer = recPlayer;
            this.here = here;
            tpaList.add(this);
        }
    }
}

