/*
 * Decompiled with CFR 0.152.
 */
package neoforge.dev.mrsnowy.teleport_commands.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.List;
import java.util.Optional;
import neoforge.dev.mrsnowy.teleport_commands.Constants;
import neoforge.dev.mrsnowy.teleport_commands.common.NamedLocation;
import neoforge.dev.mrsnowy.teleport_commands.storage.StorageManager;
import neoforge.dev.mrsnowy.teleport_commands.suggestions.WarpSuggestionProvider;
import neoforge.dev.mrsnowy.teleport_commands.utils.tools;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class warp {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setwarp").requires(source -> source.getPlayer() != null && source.hasPermission(4))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                warp.SetWarp(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while setting the warp!", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.setError", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"warp").requires(source -> source.getPlayer() != null)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WarpSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                warp.GoToWarp(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while going to the warp!", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.goError", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delwarp").requires(source -> source.getPlayer() != null && source.hasPermission(4))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WarpSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                warp.DeleteWarp(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while deleting to the warp!", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.deleteError", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"renamewarp").requires(source -> source.getPlayer() != null && source.hasPermission(4))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WarpSuggestionProvider()).then(Commands.argument((String)"newName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            String newName = StringArgumentType.getString((CommandContext)context, (String)"newName");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                warp.RenameWarp(player, name, newName);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while renaming the warp!", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.renameError", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        }))));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"warps").requires(source -> source.getPlayer() != null)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                warp.PrintWarps(player);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while printing warps!", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warps.error", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        }));
    }

    private static void SetWarp(ServerPlayer player, String warpName) throws Exception {
        System.out.println(warpName);
        warpName = warpName.toLowerCase();
        BlockPos blockPos = new BlockPos(player.getBlockX(), player.getBlockY(), player.getBlockZ());
        String worldString = player.serverLevel().dimension().location().toString();
        NamedLocation warp2 = new NamedLocation(warpName, blockPos, worldString);
        boolean warpExists = StorageManager.STORAGE.addWarp(warp2);
        if (warpExists) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.exists", player, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
        } else {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.set", player, new MutableComponent[0]), true);
        }
    }

    private static void GoToWarp(ServerPlayer player, String warpName) throws Exception {
        Optional<NamedLocation> optionalWarp = StorageManager.STORAGE.getWarp(warpName = warpName.toLowerCase());
        if (optionalWarp.isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.notFound", player, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
            return;
        }
        NamedLocation warp2 = optionalWarp.get();
        Optional<ServerLevel> optionalWorld = warp2.getWorld();
        if (optionalWorld.isEmpty()) {
            Constants.LOGGER.warn("({}) Error while going to the warp \"{}\"! \nCouldn't find a world with the id: \"{}\" \nAvailable worlds: {}", new Object[]{player.getName().getString(), warp2.getName(), warp2.getWorldString(), tools.getWorldIds()});
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.common.worldNotFound", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
            return;
        }
        ServerLevel warpWorld = optionalWorld.get();
        BlockPos teleportBlockPos = warp2.getBlockPos();
        if (player.blockPosition().equals((Object)teleportBlockPos) && player.level() == warpWorld) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.goSame", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
        } else {
            Vec3 teleportPos = new Vec3((double)teleportBlockPos.getX() + 0.5, (double)teleportBlockPos.getY(), (double)teleportBlockPos.getZ() + 0.5);
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.go", player, new MutableComponent[0]), true);
            tools.Teleporter(player, warpWorld, teleportPos);
        }
    }

    private static void DeleteWarp(ServerPlayer player, String warpName) throws Exception {
        Optional<NamedLocation> optionalWarp = StorageManager.STORAGE.getWarp(warpName = warpName.toLowerCase());
        if (optionalWarp.isPresent()) {
            StorageManager.STORAGE.removeWarp(optionalWarp.get());
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.delete", player, new MutableComponent[0]), true);
        } else {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.notFound", player, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
        }
    }

    private static void RenameWarp(ServerPlayer player, String warpName, String newWarpName) throws Exception {
        warpName = warpName.toLowerCase();
        if (StorageManager.STORAGE.getWarp(newWarpName = newWarpName.toLowerCase()).isPresent()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.common.nameExists", player, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
            return;
        }
        Optional<NamedLocation> warpToRename = StorageManager.STORAGE.getWarp(warpName);
        if (warpToRename.isPresent()) {
            warpToRename.get().setName(newWarpName);
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.rename", player, new MutableComponent[0]), true);
        } else {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.notFound", player, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
        }
    }

    private static void PrintWarps(ServerPlayer player) throws Exception {
        List<NamedLocation> warps = StorageManager.STORAGE.getWarps();
        if (warps.isEmpty()) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.warp.homeless", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
            return;
        }
        MutableComponent message = Component.empty();
        message.append((Component)tools.getTranslatedText("commands.teleport_commands.warps.warps", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        for (NamedLocation currentWarp : warps) {
            String name = String.format("  - %s", currentWarp.getName());
            String coords = String.format("[X%d Y%d Z%d]", currentWarp.getX(), currentWarp.getY(), currentWarp.getZ());
            String dimension = String.format(" [%s]", currentWarp.getWorldString());
            boolean canModify = player.hasPermissions(4);
            message.append("\n");
            message.append((Component)Component.literal((String)name).withStyle(ChatFormatting.AQUA));
            message.append("\n");
            message.append((Component)Component.literal((String)"     | ").withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)coords).withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, String.format("X%d Y%d Z%d", currentWarp.getX(), currentWarp.getY(), currentWarp.getZ())))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)tools.getTranslatedText("commands.teleport_commands.common.hoverCopy", player, new MutableComponent[0]))))).append((Component)Component.literal((String)dimension).withStyle(ChatFormatting.DARK_PURPLE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, currentWarp.getWorldString()))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)tools.getTranslatedText("commands.teleport_commands.common.hoverCopy", player, new MutableComponent[0])))));
            message.append("\n");
            message.append((Component)Component.literal((String)"     | ").withStyle(ChatFormatting.AQUA)).append((Component)tools.getTranslatedText("commands.teleport_commands.common.tp", player, new MutableComponent[0]).withStyle(ChatFormatting.GREEN).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/warp \"%s\"", currentWarp.getName()))))).append(" ");
            if (canModify) {
                message.append((Component)tools.getTranslatedText("commands.teleport_commands.common.rename", player, new MutableComponent[0]).withStyle(ChatFormatting.BLUE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/renamewarp \"%s\" ", currentWarp.getName()))))).append(" ").append((Component)tools.getTranslatedText("commands.teleport_commands.common.delete", player, new MutableComponent[0]).withStyle(ChatFormatting.RED).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/delwarp \"%s\"", currentWarp.getName())))));
            }
            message.append("\n");
        }
        player.displayClientMessage((Component)message, false);
    }
}

