/*
 * Decompiled with CFR 0.152.
 */
package neoforge.dev.mrsnowy.teleport_commands.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import java.util.Optional;
import neoforge.dev.mrsnowy.teleport_commands.Constants;
import neoforge.dev.mrsnowy.teleport_commands.TeleportCommands;
import neoforge.dev.mrsnowy.teleport_commands.utils.tools;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class worldspawn {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"worldspawn").requires(source -> source.getPlayer() != null)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                worldspawn.toWorldSpawn(player, false);
            }
            catch (Exception error) {
                Constants.LOGGER.error("Error while going to the worldspawn! => ", (Throwable)error);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.common.error", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"Disable Safety", (ArgumentType)BoolArgumentType.bool()).requires(source -> source.getPlayer() != null)).executes(context -> {
            boolean safety = BoolArgumentType.getBool((CommandContext)context, (String)"Disable Safety");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                worldspawn.toWorldSpawn(player, safety);
            }
            catch (Exception error) {
                Constants.LOGGER.error("Error while going to the worldspawn! => ", (Throwable)error);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.common.error", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })));
    }

    private static void toWorldSpawn(ServerPlayer player, boolean safetyDisabled) throws NullPointerException {
        ServerLevel world = TeleportCommands.SERVER.getLevel(Level.OVERWORLD);
        BlockPos worldSpawn = Objects.requireNonNull(world, "Overworld cannot be null!").getSharedSpawnPos();
        if (!safetyDisabled) {
            Optional<BlockPos> teleportData = tools.getSafeBlockPos(worldSpawn, world);
            if (teleportData.isPresent()) {
                BlockPos safeBlockPos = teleportData.get();
                if (player.blockPosition().equals((Object)safeBlockPos) && player.level() == world) {
                    player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.worldspawn.same", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
                } else {
                    Vec3 teleportPos = new Vec3((double)safeBlockPos.getX() + 0.5, (double)safeBlockPos.getY(), (double)safeBlockPos.getZ() + 0.5);
                    player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.worldspawn.go", player, new MutableComponent[0]), true);
                    tools.Teleporter(player, world, teleportPos);
                }
            } else {
                player.displayClientMessage((Component)Component.empty().append((Component)tools.getTranslatedText("commands.teleport_commands.common.noSafeLocation", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).append("\n").append((Component)tools.getTranslatedText("commands.teleport_commands.common.safetyIsForLosers", player, new MutableComponent[0]).withStyle(ChatFormatting.WHITE)).append("\n").append((Component)tools.getTranslatedText("commands.teleport_commands.common.forceTeleport", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.DARK_AQUA, ChatFormatting.BOLD}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/worldspawn true")))).append("\n"), false);
            }
        } else if (player.blockPosition().equals((Object)worldSpawn) && player.level() == world) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.worldspawn.same", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
        } else {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.worldspawn.go", player, new MutableComponent[0]), true);
            tools.Teleporter(player, world, new Vec3((double)worldSpawn.getX() + 0.5, (double)worldSpawn.getY(), (double)worldSpawn.getZ() + 0.5));
        }
    }
}

