/*
 * Decompiled with CFR 0.152.
 */
package neoforge.dev.mrsnowy.teleport_commands.common;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import neoforge.dev.mrsnowy.teleport_commands.TeleportCommands;
import neoforge.dev.mrsnowy.teleport_commands.storage.StorageManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public class NamedLocation {
    private String name;
    private final int x;
    private final int y;
    private final int z;
    private final String world;

    public NamedLocation(String name, BlockPos pos, String world) {
        this.name = name;
        this.x = pos.getX();
        this.y = pos.getY();
        this.z = pos.getZ();
        this.world = world;
    }

    public String getName() {
        return this.name;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getWorldString() {
        return this.world;
    }

    public Optional<ServerLevel> getWorld() {
        return StreamSupport.stream(TeleportCommands.SERVER.getAllLevels().spliterator(), false).filter(level -> Objects.equals(level.dimension().location().toString(), this.world)).findFirst();
    }

    public void setName(String name) throws Exception {
        this.name = name;
        StorageManager.StorageSaver();
    }
}

