/*
 * Decompiled with CFR 0.152.
 */
package neoforge.dev.mrsnowy.teleport_commands.suggestions;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import neoforge.dev.mrsnowy.teleport_commands.Constants;
import neoforge.dev.mrsnowy.teleport_commands.common.NamedLocation;
import neoforge.dev.mrsnowy.teleport_commands.common.Player;
import neoforge.dev.mrsnowy.teleport_commands.storage.StorageManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;

public class HomeSuggestionProvider
implements SuggestionProvider<CommandSourceStack> {
    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            Optional<Player> optionalPlayerStorage = StorageManager.STORAGE.getPlayer(player.getStringUUID());
            if (optionalPlayerStorage.isPresent()) {
                Player playerStorage = optionalPlayerStorage.get();
                for (NamedLocation currentHome : playerStorage.getHomes()) {
                    builder.suggest(currentHome.getName());
                }
            }
            return builder.buildFuture();
        }
        catch (Exception e) {
            Constants.LOGGER.error("Error getting home suggestions! ", (Throwable)e);
            return null;
        }
    }
}

