/*
 * Decompiled with CFR 0.152.
 */
package fabric.dev.mrsnowy.teleport_commands.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fabric.dev.mrsnowy.teleport_commands.Constants;
import fabric.dev.mrsnowy.teleport_commands.common.DeathLocation;
import fabric.dev.mrsnowy.teleport_commands.storage.DeathLocationStorage;
import fabric.dev.mrsnowy.teleport_commands.utils.tools;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class back {
    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"back").requires(source -> source.method_44023() != null)).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                back.ToDeathLocation(player, false);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while going back! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.common.error", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"Disable Safety", (ArgumentType)BoolArgumentType.bool()).requires(source -> source.method_44023() != null)).executes(context -> {
            boolean safety = BoolArgumentType.getBool((CommandContext)context, (String)"Disable Safety");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                back.ToDeathLocation(player, safety);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while going back! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.common.error", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
    }

    private static void ToDeathLocation(class_3222 player, boolean safetyDisabled) throws Exception {
        class_2338 teleportBlockPos;
        DeathLocation deathLocation = DeathLocationStorage.getDeathLocation(player.method_5845()).orElse(null);
        if (deathLocation == null) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.common.noLocation", player, new class_5250[0]).method_27692(class_124.field_1061), true);
            return;
        }
        class_3218 deathLocationWorld = deathLocation.getWorld().orElse(null);
        if (deathLocationWorld == null) {
            Constants.LOGGER.warn("({}) Error while going back! \nCouldn't find a world with the id: \"{}\" \nAvailable worlds: {}", new Object[]{player.method_5477().getString(), deathLocation.getWorldString(), tools.getWorldIds()});
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.common.worldNotFound", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
            return;
        }
        if (!safetyDisabled) {
            Optional<class_2338> safeBlockPos = tools.getSafeBlockPos(deathLocation.getBlockPos(), deathLocationWorld);
            if (safeBlockPos.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43473().method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.noSafeLocation", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).method_27693("\n").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.safetyIsForLosers", player, new class_5250[0]).method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.forceTeleport", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/back true")))).method_27693("\n"), false);
                return;
            }
            teleportBlockPos = safeBlockPos.get();
        } else {
            teleportBlockPos = deathLocation.getBlockPos();
        }
        if (player.method_24515().equals((Object)teleportBlockPos) && player.method_37908() == deathLocationWorld) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.back.same", player, new class_5250[0]).method_27692(class_124.field_1075), true);
        } else {
            class_243 teleportPos = new class_243((double)teleportBlockPos.method_10263() + 0.5, (double)teleportBlockPos.method_10264(), (double)teleportBlockPos.method_10260() + 0.5);
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.back.go", player, new class_5250[0]), true);
            tools.Teleporter(player, deathLocationWorld, teleportPos);
        }
    }
}

